% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistHR.R
\name{DistHR}
\alias{DistHR}
\title{Null Distribution of the Estimated HR}
\usage{
DistHR(
  Survival,
  Censor,
  Micro.mat,
  Prognostic = NULL,
  Mean = TRUE,
  Quantile = 0.5,
  Reduce = FALSE,
  Select = 5,
  nperm = 100,
  case = 2,
  Method = "BH",
  Validation = c("PLSbased", "PCAbased", "L1based", "MVbased")
)
}
\arguments{
\item{Survival}{A vector of survival time with length equals to number of subjects.}

\item{Censor}{A vector of censoring indicator.}

\item{Micro.mat}{A large or small microbiome profile matrix. A matrix with microbiome profiles where the number of rows should be equal to the number of taxa and number of columns should be equal to number of patients.}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Mean}{The cut off value for the classifier, default is the mean cutoff.}

\item{Quantile}{If user want to use quantile as cutoff point. They need to specify Mean = FALSE and a quantile that they want to use. The default is the median cutoff.}

\item{Reduce}{A boolean parameter indicating if the microbiome profile matrix should be reduced, default is TRUE and larger microbiome profile matrix is reduced by supervised pca approach and first pca is extracted from the reduced matrix to be used in the classifier.}

\item{Select}{Number of taxa (default is 5) to be selected from supervised PCA. This is valid only if the argument Reduce=TRUE.}

\item{nperm}{Number of permutations to be used and default 100.}

\item{case}{There are seven different ways on how to call this argument:
\enumerate{
\item{Permute survival only.}
\item{Permute survival and rows of data frame of the prognostic factors.}
\item{Permute survival, rows of data frame of the prognostic factors, columns of microbiome matrix independently.}
\item{Permute microbiome matrix only.}
}}

\item{Method}{A multiplicity adjustment Method that user can choose. The default is BH Method.}

\item{Validation}{There are four different validation schemes where the null distribution can be estimated. That is c("PLSbased","PCAbased","L1based","MVbased").}
}
\value{
A object of class \code{\link[MicrobiomeSurv]{perm}} is returned with the following values
  \item{HRobs}{Estimated HR for low risk group on the original data.}
  \item{HRperm}{Estimated HR for low risk group on the permuted data.}
  \item{nperm}{Number of permutations carried out.}
  \item{Validation}{The validation scheme that was used.}
}
\description{
This function generates the null distribution of the HR by permutation approach either using a large microbiome matrix or a reduced version by supervised pca approach.
Several ways of permutation setting can be implemented.
That is, the function can be used to generate null distributions for four different validation schemes which are PLS based, PCA based, Majority votes based and Lasso based.
Note this function internally calls function  \code{\link[MicrobiomeSurv]{SurvPcaClass}}, \code{\link[MicrobiomeSurv]{SurvPlsClass}}, \code{\link[MicrobiomeSurv]{Majorityvotes}}, and \code{\link[MicrobiomeSurv]{Lasoelascox}}.
}
\examples{
\donttest{
# Prepare data
data(Week3_response)
Week3_response = data.frame(Week3_response)
surv_fam_shan_w3 = data.frame(cbind(as.numeric(Week3_response$T1Dweek),
as.numeric(Week3_response$T1D)))
colnames(surv_fam_shan_w3) = c("Survival", "Censor")
prog_fam_shan_w3 = data.frame(factor(Week3_response$Treatment_new))
colnames(prog_fam_shan_w3) = c("Treatment")
data(fam_shan_trim_w3)
names_fam_shan_trim_w3 =
c("Unknown", "Lachnospiraceae", "S24.7", "Lactobacillaceae", "Enterobacteriaceae", "Rikenellaceae")
fam_shan_trim_w3 = data.matrix(fam_shan_trim_w3[ ,2:82])
rownames(fam_shan_trim_w3) = names_fam_shan_trim_w3
# Using the function
DistHR_fam_shan_w3 = DistHR(Survival = surv_fam_shan_w3$Survival,
                            Micro.mat = fam_shan_trim_w3,
                            Censor = surv_fam_shan_w3$Censor,
                            Prognostic=prog_fam_shan_w3,
                            Mean = TRUE,
                            Quantile=0.5,
                            Reduce= FALSE,
                            Select = 5,
                            nperm=100,
                            case=4,
                            Method = "BH",
                            Validation="PCAbased")

# Method that can be used for the result
show(DistHR_fam_shan_w3)
summary(DistHR_fam_shan_w3)
plot(DistHR_fam_shan_w3)
}
}
\seealso{
\code{\link[survival]{coxph}}, \code{\link[MicrobiomeSurv]{EstimateHR}}, \code{\link[MicrobiomeSurv]{SurvPcaClass}}, \code{\link[MicrobiomeSurv]{SurvPlsClass}}, \code{\link[MicrobiomeSurv]{Majorityvotes}}, \code{\link[MicrobiomeSurv]{Lasoelascox}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
