% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZerosPerGroup.R
\name{ZerosPerGroup}
\alias{ZerosPerGroup}
\title{This function returns a matrix with rows are Micros and 9 columns containing number and the proportion of zeros per groups of treatments and in total.}
\usage{
ZerosPerGroup(
  Micro.mat,
  groups,
  week = 0,
  n.obs = n.obs,
  n.control = n.control,
  n.treated = n.treated,
  n.mi = n.mi,
  plot = FALSE
)
}
\arguments{
\item{Micro.mat}{Micro matrix (rows are Micros, columns are subjects)}

\item{groups}{Treatment groups or groups of any binary variables}

\item{week}{A specific time point. To use when having different time points in the dataset.}

\item{n.obs}{Number of patients.}

\item{n.control}{Number of patients in control group or in the first group.}

\item{n.treated}{Number of patients in treated group or in the second group.}

\item{n.mi}{Number of taxa.}

\item{plot}{A boolean parameter indicating if the plot should be shown. Default is FALSE.}
}
\value{
A matrix with information of number and the proportion of zeros per groups.
\item{zero.per.group}{A matrix with rows are Micros and 9 columns containing number and the proportion of zeros per groups of treatments and in total.}
\item{plot}{Plot percentage of zeros per group}
}
\description{
This function returns a matrix with rows are Micros and 9 columns containing number and the proportion of zeros per groups of treatments and in total.
}
\examples{
\donttest{
# Preparing data for analysis at OTU level
data(Week3_otu)
data(Week3_response)
Week3_otu = data.frame(Week3_otu)
otu_mat_w3 = t(data.matrix(Week3_otu[ , 1:2720]))
n_obs = dim(otu_mat_w3)[2]
n_control = table(Week3_response$Treatment_new)[1]
n_treated = table(Week3_response$Treatment_new)[2]
n_otu = dim(otu_mat_w3)[1]
# Calculate zeros per groups
zero_per_group_otu_w3 = ZerosPerGroup(Micro.mat = otu_mat_w3,
                                     groups = Week3_response$Treatment_new,
                                     week = 3,
                                     n.obs = n_obs,
                                     n.control = n_control,
                                     n.treated = n_treated,
                                     n.mi = n_otu,
                                     plot = TRUE)
}
}
\seealso{
\code{\link[MicrobiomeSurv]{ZerosPerGroup}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
