% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_segments.R
\name{detect_segments}
\alias{detect_segments}
\title{detect_segments}
\usage{
detect_segments(
  locs,
  times,
  param_min_days = 2,
  param_prop_days = 0.05,
  param_window_size_days = 20,
  param_ol_min_frac = 1,
  return_intermediate_results = FALSE
)
}
\arguments{
\item{locs}{(character). A vector containing locations corresponding to \code{times }.}

\item{times}{(POSIXct). A vector containing timestamps corresponding to \code{locs}.}

\item{param_min_days}{(Optional) numeric. The minimum length in days of a segment. Smaller segments will be eliminated during stage 1. Default is \code{2}.}

\item{param_prop_days}{(Optional) numeric. The minimum fraction of days in a segment during which a user must have been observed at a location. Segments with a smaller proportion will be eliminated. Default is \code{0.05}.}

\item{param_window_size_days}{(Optional) numeric. The minimum forward window size in days for step 1. Observations separated by a smaller timespan will be connected. Default is \code{20}.}

\item{param_ol_min_frac}{(Optional) numeric. In step 3, do not remove the overlapped segment if the place it belongs to is the mode during the period of overlap and if the place contains more than this fraction of all occurrences. Default is 1 meaning that no segments can persist at overlaps.}

\item{return_intermediate_results}{(Optional) logical. Should the results of Step 1 and 2 be returned as well? If \code{TRUE} the result will be a list of length 3. Default is \code{FALSE}.}
}
\value{
A \link[tibble]{tibble} containing the detected segments as \link[lubridate]{interval} with their location as Character.
}
\description{
A three step algorithm to identify segments of continuous presence within trace data
}
\details{
\itemize{
The first step in detecting migration requires detecting periods of time when
an individual is continuously present in a single location,
allowing for some margin of travel from that location (Chi et al., 2020).

These segments are identified from the time series of \code{locs} and \code{times} in a
three-step procedure:
\item{Step 1: \strong{Identify} contiguous segments, with no gap exceeding \code{param_window_size_days days},
where the individual is present for at least \code{param_prop_days} percent of days in the segment,
and the total length of the segment is at least \code{param_min_days}},
\item{Step 2: \strong{Merge} segments if there are no segments in other locations between them.},
\item{Step 3: \strong{Prune} overlapping time from segments,
when an individual is associated with segments in multiple locations at a single point in time.
overlapping segments may be allowed to persist if they
contain at least \code{param_ol_min_frac} of all observations during the overlap period.}}
}
\examples{
trace <- MigrationDetectR::example_trace

# Detect segments
segments <-
  detect_segments(
      locs = trace$location,
      times = trace$timestamp,
      param_min_days = 3,
      param_prop_days = 0.06,
      param_window_size_days = 7,
      param_ol_min_frac= 0.5)
 nrow(segments) # check the number of detected segments
 head(segments) # check the segments
}
\references{
Chi, Guanghua, Fengyang Lin, Guangqing Chi, and Joshua Blumenstock. 2020. “A General Approach to Detecting Migration Events in Digital Trace Data.” Edited by Song Gao. PLOS ONE 15 (10): e0239408. https://doi.org/10.1371/journal.pone.0239408.
}
\author{
Johannes Mast \email{Johannes.Mast@dlr.de}, based on the algorithm by Guanghua Chi \email{guanghua@berkeley.edu}
}
