% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OrderMissing.R
\name{OrderMissing}
\alias{OrderMissing}
\alias{print.orderpattern}
\alias{summary.orderpattern}
\title{Order Missing Data Pattern}
\usage{
OrderMissing(data, del.lesscases = 0)
}
\arguments{
\item{data}{A matrix or data frame consisting of at least two columns. Values must be numerical with missing data indicated by NA.}

\item{del.lesscases}{Missing data patterns consisting of del.lesscases number of cases or less will be removed from the data set.}
}
\value{
An object of class \code{orderpattern} - a list including elements:
\item{data }{A matrix containing the rearranged data set}
\item{caseorder}{A mapping of case number indices from output (ordered) data to input data. More specifically, the j-th row of the output (ordered) 
  data is the caseorder[j]-th (the j-th element of caseorder) row of the input data.}
\item{patused }{A matrix indicating the missing data patterns in the data set, using 1's' (for observed) and NA's (for missing)}
\item{patcnt}{A vector consisting the number of cases corresponding to each pattern in patused}
\item{spatcnt}{Cumulative sum of elements of patcnt}
\item{g}{Number of missing data patterns}
\item{removedcases }{The index of cases that were removed from the original data set}
}
\description{
This function rearranges the data based on their missing data patterns. 
Morever, missing data patterns consisting of fewer than the user specified number in del.lesscases is deleted from the dataset.
}
\note{
If you run the following command line:
out <- OrderMissing(data=y, del.lesscases=0),
then y[out$caseorder,] is equal to the output data (i.e. out$data). 
Also out$data[order(out$caseorder),] is equal to the original data y. Note that
if del.lesscases is greater than zero, the command out$data[order(out$caseorder),] will result in
a data set that has no case order correspondnce to the original data.
}
\examples{
set.seed <- 50
n <- 200
p <- 4
pctmiss <- 0.2
y <- matrix(rnorm(n * p),nrow = n)
missing <- matrix(runif(n * p), nrow = n) < pctmiss
y[missing] <- NA
out <- OrderMissing(y, del.lesscases = 0)
a <- out$caseorder
z = out$data
y[a,] # Reverting the original data to the new output order
z[order(a),] # Reverting the ordered datat to the original order
}
\author{
Mortaza Jamshidian, Siavash Jalal, and Camden Jansen
}
