% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{compare_methods_with_gibbs}
\alias{compare_methods_with_gibbs}
\title{Compare estimation methods with and without Gibbs sampling}
\usage{
compare_methods_with_gibbs(
  data,
  em_params,
  ecf_kernel_params,
  ecf_empirical_params,
  fig_dir = tempdir()
)
}
\arguments{
\item{data}{Numeric vector of observations.}

\item{em_params}{List of EM-estimated parameters.}

\item{ecf_kernel_params}{List of kernel ECF-estimated parameters.}

\item{ecf_empirical_params}{List of empirical ECF-estimated parameters.}

\item{fig_dir}{Optional path to save plots. Defaults to tempdir().}
}
\value{
NULL (plots are saved to fig_dir)
}
\description{
Visualizes and compares mixture fits from EM, ECF (kernel and empirical), and Gibbs sampling.
}
