% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.pheno.single.R
\name{get.pheno.single}
\alias{get.pheno.single}
\title{Export underlying phenotypes}
\usage{
get.pheno.single(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  use.all.copy = FALSE,
  use.id = TRUE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{use.all.copy}{Set to TRUE to extract phenotyping}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names (default: TRUE)}
}
\value{
Phenotypes for in gen/database/cohorts selected individuals
}
\description{
Function to export underlying phenotypes
}
\examples{
data(ex_pop)
get.pheno.single(ex_pop, gen=2)
}
