% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.uhat.R
\name{get.uhat}
\alias{get.uhat}
\title{Export estimated SNP effects}
\usage{
get.uhat(population, extend = FALSE, plot = TRUE, trait.plot = 1)
}
\arguments{
\item{population}{Population list}

\item{extend}{Set to TRUE to export u_hat estimates from all breeding values instead of just the last (default: FALSE)}

\item{plot}{Set to FALSE to not display overview of estimated SNP effects (default: TRUE)}

\item{trait.plot}{Select trait for which to generate the visualization (default: 1)}
}
\value{
matrix with estimated marker effects
}
\description{
Function to export estimated SNP effects
}
\examples{
data(ex_pop)
population = breeding.diploid(ex_pop, bve.gen = 2:3, genotyped.gen = 2:3,
 bve = TRUE, estimate.u = TRUE)
get.uhat(population)
}
