% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_matrix_model.r
\name{ModelMatrixModel}
\alias{ModelMatrixModel}
\title{ModelMatrixModel() function}
\usage{
ModelMatrixModel(
  rformula,
  data,
  sparse = TRUE,
  center = FALSE,
  scale = FALSE,
  remove_1st_dummy = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{rformula}{a formula, e.g. formula("~ 1+x1+x2"),"~ 1+x1+x2",or ~ 1+x1+x2 . Note the interpreting of the formula might be different slightly from model.matrix function. In model.matrix(),intercept column will be included in output matrix with or without "1" in the formula. But in ModelMatrixModel(),intercept column will  be included in output matrix only when  "1" is present. Moreover "0" or "." in the formula will be ignored.}

\item{data}{a data.frame.}

\item{sparse}{boolean, if TRUE return a sparse matrix, i.e. a "dgCMatrix" class.}

\item{center}{boolean, if center the output.}

\item{scale}{boolean, if scale the output.}

\item{remove_1st_dummy}{boolean, if remove the first dummy variable in one hot key transformation.}

\item{verbose}{boolean, if print out progress.}
}
\value{
A ModelMatrixModel class,which includes the transformed matrix and  the transforming parameters.
}
\description{
This function  transforms a data.frame to matrix (or sparse matrix)  based on a r formula. The mean different from model.matrix() function is that it outputs a class stored with the transformed matrix, as well as the transforming parameters which can be applied to new data.
}
\details{
see vignettes.
}
\examples{
library(ModelMatrixModel)
traindf= data.frame(x1 = sample(LETTERS[1:5], replace = TRUE, 20),
                    x2 = rnorm(20, 100, 5),
                    y = rnorm(20, 10, 2))
mm=ModelMatrixModel(~x1+x2,traindf,remove_1st_dummy = FALSE)
data.frame(as.matrix(head(mm$x,2)))
}
