% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MonotoneHR.R
\name{monotoneHR}
\alias{monotoneHR}
\title{Estimate a non-decreasing hazard ratio function, together with a 100(1-\eqn{\alpha})\% confidence interval}
\usage{
monotoneHR(time.grid, S.data, T.data, ci.lvl = 0.05)
}
\arguments{
\item{time.grid}{A vector on which the hazard ratio function to be evaluated}

\item{S.data}{A dataframe containing observed survival time and censoring, it corresponds to the hazard function on the numerator}

\item{T.data}{A dataframe containing observed survival time and censoring, it corresponds to the hazard function on the demoninator}

\item{ci.lvl}{A number that specify the confidence level \eqn{\alpha}. Default is 0.05.}
}
\value{
\code{hr} The estimated hazard ratio

\code{tau} The estimated scaled parameter of the limiting Chernoff distribution

\code{ci.upper} and \code{ci.lower} are the upper bound and lower bound of the estimated confidence interval
}
\description{
Estimate a non-decreasing hazard ratio function, together with a 100(1-\eqn{\alpha})\% confidence interval
}
\examples{
# load the example data
data(survData)
# load the computed Chernoff distribution
data("chernoff_realizations")
# split the data into two groups S and T, make sure that the column of survival time
# is named as "time", and the column of censoring named as "status" (0 as being censored)
s.data <- survData[survData$group == 'S',]
t.data <- survData[survData$group == 'T',]
# define the evaluation grid on which the hazard ratio function is to be computed
t.grid <- seq(0, 10, 1)
# estimation and inference of the non-decreasing hazard ratio (defined as
#\eqn{\lambda_S}/\eqn{\lambda_T}, where \eqn{\lambda} is the hazard function) function
theta <- monotoneHR(t.grid, s.data, t.data)
}
