% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsupport.R
\name{modelsupport}
\alias{modelsupport}
\title{Evaluate model support}
\usage{
modelsupport(models)
}
\arguments{
\item{models}{a \code{regions_modelselect} object; the output of a call to \code{\link[=modelselect]{modelselect()}}.}
}
\value{
A \code{regions_modelsupport} object, which contains the best model for each number of regions as determined by the AICc and BIC. The computed statistics are \code{AICc}/\code{BIC}--the value of the information criterion (IC) for each model, \code{deltaAIC}/\code{deltaBIC}--the difference between the IC for the corresponding model and that of the model with the lowest IC value, \code{model_lik}--the likelihood ratio of the model against the model with the lowest IC value, and \code{Ak_weight}/\code{BIC_weight}--the Akaike weights for each model used to compute the region score. The region score is a weighted average of the numbers of regions, weighted by the Akaike weights to represent the variability around the optimal number of regions.
}
\description{
\code{modelsupport()} computes measures of the relative support of each of the best models identified by \code{\link[=modelselect]{modelselect()}} to facilitate selecting the optimal number and position of regions. These measures are in the form of information criteria (AICc and BIC).
}
\examples{
data("alligator")

alligator_data <- process_measurements(alligator,
                                       pos = "Vertebra")

# Compute PCOs
alligator_PCO <- svdPCO(alligator_data)

# Fit segmented regression models for 1 to 7 regions
# using PCOs 1 to 4 and a continuous model with a
# non-exhaustive search
regionresults <- calcregions(alligator_PCO,
                             scores = 1:4,
                             noregions = 7,
                             minvert = 3,
                             cont = TRUE,
                             exhaus = FALSE,
                             verbose = FALSE)

regionresults

# For each number of regions, identify best
# model based on minimizing RSS
bestresults <- modelselect(regionresults)
bestresults

# Evaluate support for each model and rank models
supp <- modelsupport(bestresults)
supp

# 5 regions best based on AICc; 6 regions based on BIC
}
\seealso{
\code{\link[=modelselect]{modelselect()}}, \code{\link[=calcregions]{calcregions()}}, \code{\link[=calcBPvar]{calcBPvar()}}, \code{\link[=modelperf]{modelperf()}}, \code{\link[=plotsegreg]{plotsegreg()}}
}
