% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ILDS.r
\name{visualize}
\alias{visualize}
\alias{visualize.ILDSR2}
\alias{visualise}
\alias{visualise.ILDSR2}
\title{Plot the ILDS with the relevant ILDS ighlighted}
\usage{
visualize(x, ...)

\method{visualize}{ILDSR2}(
  x,
  ref = TRUE,
  relcol = "red",
  rescol = "black",
  lwd = 1,
  cex = 2,
  col = "red",
  pch = 19,
  contractcol = c("red", "orange"),
  expandcol = c("blue", "cyan"),
  conftol = c(75, 50),
  useconf = TRUE,
  add = FALSE,
  plot.legend = FALSE,
  ngrid = 0,
  gridcol = "grey90",
  gridlty = 3,
  links = NULL,
  linkcol = "grey50",
  lollipop = TRUE,
  lollipopcol = "black",
  magnify = 1,
  ...
)

visualise(x, ...)

\method{visualise}{ILDSR2}(
  x,
  ref = TRUE,
  relcol = "red",
  rescol = "black",
  lwd = 1,
  cex = 2,
  col = "red",
  pch = 19,
  contractcol = c("red", "orange"),
  expandcol = c("blue", "cyan"),
  conftol = c(75, 50),
  useconf = TRUE,
  add = FALSE,
  plot.legend = FALSE,
  ngrid = 0,
  gridcol = "grey90",
  gridlty = 3,
  links = NULL,
  linkcol = "grey50",
  lollipop = TRUE,
  lollipopcol = "black",
  magnify = 1,
  ...
)
}
\arguments{
\item{x}{output of function \code{\link{ILDSR2}}}

\item{...}{additional parameters passed to  \code{\link{deformGrid2d}} /  \code{\link{deformGrid3d}}.}

\item{ref}{logical: if TRUE, the reference shape defined in  \code{\link{ILDSR2}} will be plotted. Otherwise the target is used. If \code{ref=FALSE}, the contraction and exxpansion will also be inverted}

\item{relcol}{color of relevant ILDs}

\item{rescol}{color of "irrelevant" ILDs}

\item{lwd}{numeric: define line width. Relevant ILDs are displayed by \code{3*lwd}.}

\item{cex}{numeric: size of plot content}

\item{col}{define color of landmarks}

\item{pch}{define symbols used to plot landmarks in 2D plot.}

\item{contractcol}{vector of colors for shortening ILDs, associated with confidence. Must be of \code{length(contol)}.}

\item{expandcol}{vector of colors for expanding ILDs, associated with confidence. Must be of \code{length(contol)}.}

\item{conftol}{vector: set thresholds for confidence coloring}

\item{useconf}{logical: if TRUE, highlighting according to supported confidence of ILD is applied.}

\item{add}{logical: if TRUE, plot is added to an existin one.}

\item{plot.legend}{logical: if TRUE, a legend is added to the plots with information on the coloring scheme.}

\item{ngrid}{integer: if \code{ngrid > 0}, a TPS grid is shown to display the spatial deformation from reference to target shape.}

\item{gridcol}{color of TPS grid}

\item{gridlty}{line type for TPS grid}

\item{links}{integer vector or list containing multiple integer vectors or a k x 2 integer matrix where each row defines a single link: add information on how landmarks are linked (aka wireframe)}

\item{linkcol}{color of wireframe defined by \code{links}}

\item{lollipop}{logical: if TRUE, landmark displacement between reference and target is displayed as lollipop graph.}

\item{lollipopcol}{color for lollipop handles}

\item{magnify}{numeric: symmetrically increase differences between reference and target by that factor}
}
\description{
Plot the ILDS with the relevant ILDS ighlighted
}
\examples{
## 3D Example
require(Morpho)
data(boneData)
proc <- procSym(boneLM)
groups <- name2factor(boneLM,which=3)
ilds <- ILDSR2(proc$rotated,groups,plot=FALSE,bg.rounds=0,wg.rounds=99)
visualize(ilds)

## 2D Example
require(shapes)
gor.dat <- bindArr(gorf.dat,gorm.dat,along=3)
sex <- factor(c(rep("f",30),rep("m",29)))
procg <- procSym(gor.dat)
ildsg <- ILDSR2(procg$rotated,sex,plot=FALSE,bg.rounds=0,wg.rounds=99,R2tol=.9)
visualize(ildsg,cex=2,pch=19)

## use custom color and thresholds
visualize(ildsg,cex=2,pch=19,confcol=rainbow(5),contractcol=c(0.9,0.6,0.4))
}
