% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runModels.R
\name{runModels}
\alias{runModels}
\title{Run Mplus Models}
\usage{
runModels(
  target = getwd(),
  recursive = FALSE,
  filefilter = NULL,
  showOutput = FALSE,
  replaceOutfile = "always",
  logFile = "Mplus Run Models.log",
  Mplus_command = detectMplus(),
  killOnFail = TRUE,
  local_tmpdir = FALSE,
  quiet = TRUE
)
}
\arguments{
\item{target}{a character vector where each element is a directory containing Mplus input files
(.inp) to run OR a single .inp file to be run. Elements may be a full path, relative path,
or a filename within the working directory.
Defaults to the current working directory. Example: \dQuote{C:/Users/Michael/Mplus Runs}}

\item{recursive}{optional. If \code{TRUE}, run all models nested in subdirectories
within \code{directory}. Defaults to \code{FALSE}. Not relevant if \code{target} is a single file.}

\item{filefilter}{a Perl regular expression (PCRE-compatible) specifying particular input
files to be run among those found in \code{target}. See \code{regex} or \url{https://www.pcre.org/pcre.txt}
for details about regular expression syntax.}

\item{showOutput}{optional. If \code{TRUE}, show estimation output (TECH8)
in the R console. Note that if run within Rgui, output will display within R,
but if run via Rterm, a separate window will appear during estimation.}

\item{replaceOutfile}{optional. Currently supports three settings: \dQuote{always}, which
runs all models, regardless of whether an output file for the model exists; \dQuote{never},
which does not run any model that has an existing output file; and \dQuote{modifiedDate}, which
only runs a model if the modified date for the input file is more recent than
the output file modified date (implying there have been updates to the model).}

\item{logFile}{optional. If non-null, specifies a file (and optionally, directory)
that records the settings passed into the function and the models run (or skipped)
during the run.}

\item{Mplus_command}{optional. N.B.: No need to pass this parameter for most users (has intelligent
defaults). Allows the user to specify the name/path of the Mplus executable to be used for
running models. This covers situations where Mplus is not in the system's path,
or where one wants to test different versions of the Mplus program.}

\item{killOnFail}{optional. Windows only for now. If \code{TRUE}, kill all processes named mplus.exe when
\code{runModels} does not terminate normally. Defaults to \code{TRUE}.}

\item{local_tmpdir}{optional. Linux/Mac for now. If \code{TRUE}, set the TMPDIR environment variable to the
location of the .inp file prior to execution. This is useful in Monte Carlo studies where many instances of Mplus
may run in parallel and we wish to avoid collisions in temporary files among processes.}

\item{quiet}{optional. If \code{FALSE}, show status messages in the console.}
}
\value{
None. Function is used for its side effects (running models).
}
\description{
This function runs a group of Mplus models (.inp files) located within a
single directory or nested within subdirectories.
}
\examples{
\dontrun{
  runModels("C:/Users/Michael/Mplus Runs", recursive=TRUE, showOutput=TRUE,
    replaceOutfile="modifiedDate", logFile="MH_RunLog.txt",
    Mplus_command="C:\\\\Users\\\\Michael\\\\Mplus Install\\\\Mplus51.exe")
}
\dontrun{
  runModels(getwd(), filefilter = "ex8.*", logFile=NULL)
}
}
\seealso{
\code{\link{runModels_Interactive}}
}
\author{
Michael Hallquist
}
\keyword{interface}
