% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitGCM.R
\name{fitGCM}
\alias{fitGCM}
\title{Fit Growth Curve Models (GCM)}
\usage{
fitGCM(
  data,
  outvar,
  catvar = FALSE,
  idvar,
  starting_val = 500,
  polynomial = 1,
  timescores = timescores,
  timescores_indiv = FALSE,
  estimator = c("MLR", "ML", "WLSMV", "WLS"),
  transformation = c("LOGIT", "PROBIT"),
  output = c("TECH1", "SAMPSTAT", "STANDARDIZED"),
  plot = "PLOT3",
  save = "FSCORES",
  wd = "Results"
)
}
\arguments{
\item{data}{A data frame containing all variables for the trajectory analysis.}

\item{outvar}{A character vector specifying the outcome variables at different times.}

\item{catvar}{A logical value indicating whether the outcome variable is categorical. Default is \code{FALSE}.}

\item{idvar}{A character string specifying the ID variable.}

\item{starting_val}{A numeric value specifying the number of random starting values to generate for the initial optimization stage.
Note that the number of final stage optimizations will be set as equal to half of this value.}

\item{polynomial}{An integer specifying the order of the polynomial used to model trajectories. Supported values are:
1 (linear), 2 (quadratic), 3 (cubic). Default is 1.}

\item{timescores}{A numeric vector specifying the time scores for the model. If \code{timescores_indiv = TRUE},
a character vector should be used to specify variables with individually varying times of observation.}

\item{timescores_indiv}{A logical value indicating whether to use individually varying times of observation for the outcome variable. Default is \code{FALSE}.}

\item{estimator}{A character string to specify the estimator to use in the analysis. Default is 'MLR'.}

\item{transformation}{A character string to specify the latent response variable transformation to use when the outcome variable is categorical. Default is \code{LOGIT}.}

\item{output}{A character vector specifying the requested Mplus output options for the model.}

\item{plot}{A character string specifying the requested Mplus plot options for the model.}

\item{save}{A character string specifying the type of results to be saved by Mplus.}

\item{wd}{A character string specifying the directory where the results folder will be created for saving Mplus input, output, and data files.
Default is the current working directory.}
}
\value{
A list of class \code{mplusObject}s including results for the fitted GCM.
}
\description{
Customize and execute GCM in Mplus, offering flexibility in model configuration and parameter estimation.
}
\details{
The \code{fitGCM} function automates the process of specifying, customizing and fitting GCM in Mplus.

This function builds upon the capabilities of the \code{\link[MplusAutomation]{mplusObject}} and \code{\link[MplusAutomation]{mplusModeler}} functions
from the MplusAutomation package.
}
\examples{
\donttest{
# Example usage:
GCM_model <- fitGCM(
  data = symptoms,
  outvar = paste("sx", seq(from = 0, to = 24, by = 6), sep = "_"),
  catvar = FALSE,
  idvar = "id",
  starting_val = 500,
  polynomial = 3,
  timescores = seq(from = 0, to = 24, by = 6),
  timescores_indiv = FALSE,
  output = c("TECH1", "SAMPSTAT", "STANDARDIZED"),
  plot = "PLOT3",
  save = "FSCORES",
  wd = file.path("Results", "Trajectories")
  )
}
}
\seealso{
\code{\link{LGMobject}} for creating the mplusObject of a latent growth model.
\code{\link{runLGM}} for conducting latent growth modelling with an mplusObject.
}
