% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.DCDA.R
\name{plot.DCDA}
\alias{plot.DCDA}
\title{Plots for \code{\link[MultANOVA]{DCDA}} objects}
\usage{
\method{plot}{DCDA}(
  x,
  axes = c(1, 2),
  pair.comp = NULL,
  alpha = 0.05,
  select.var = 1:nrow(x$var.coord),
  select.level = 1:nrow(x$level.coord),
  title = NULL,
  size = 2.25,
  expansion.var = 1.25,
  ...
)
}
\arguments{
\item{x}{An object resulting from \code{\link[MultANOVA]{DCDA}}.}

\item{axes}{Which dimensions should be plotted?}

\item{pair.comp}{An optional objects resulting from \code{\link[MultANOVA]{MultLSD}}. When provided, no discriminated modalities of the factor at the \strong{alpha} risk will linked on the plot.}

\item{alpha}{The alpha risk to determine evaluate significance of the p-values from \strong{ pair.comp}.}

\item{select.var}{The indices of the variables to be plotted. By default all variables are plotted.}

\item{select.level}{The indices of the levels of the term to be plotted. By default all levels of the term are plotted.}

\item{title}{An optional character specifying a title for the plot.}

\item{size}{The overall size of labels, points, etc.}

\item{expansion.var}{The factor of expansion applied to variables coordinates to increase readability}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The required plot.
}
\description{
Plots results from \code{\link[MultANOVA]{DCDA}} with possible customizations from the different arguments.
}
\examples{
data(OTU)
acd=DCDA(~Lot+Atm+Time,OTU[,1:4],OTU[,-c(1:4)],"Time")
lsd=MultLSD(~Lot+Atm+Time,OTU[,1:4],OTU[,-c(1:4)],"Time")
fish=FisherS(~Lot+Atm+Time,OTU[,1:4],OTU[,-c(1:4)],"Time")
plot(acd,axes = c(1,2),pair.comp = lsd,expansion.var = 1.5,select.var = which(fish[2,]<=0.05))
}
