% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct.R
\name{reconstruct_recursive}
\alias{reconstruct_recursive}
\title{Apply a clustering algorithm recursively to a given time course.}
\usage{
reconstruct_recursive(
  readouts,
  method = "kmedoids",
  sim = MultIS::get_similarity_matrix(readouts = readouts, upper = TRUE),
  split_similarity = 0.7,
  combine_similarity = 0.9,
  use_silhouette = TRUE,
  cluster_obj = FALSE
)
}
\arguments{
\item{readouts}{The time course for which to find clusters.}

\item{method}{Either "kmedoids", "kmeans" or any string permitted as a
method for stats::hclust.}

\item{sim}{A similarity matrix used with all methods except "kmeans".}

\item{split_similarity}{Similarity Threshold. If any two elements within a
cluster are below this threshold, another split is
initiated.}

\item{combine_similarity}{After Splitting, a combination phase is activated.
If any two elements between two clusters have a
similarity higher than this threshold, the cluster
are combined.}

\item{use_silhouette}{If TRUE, silhouette is used to define number of cluster
during splitting, otherwise cluster are always split
into two new clusters.}

\item{cluster_obj}{If TRUE, a clusterObject with the readouts, similarity
and clustering is returned.}
}
\value{
A matrix with two columns: "Clone" and "IS" or if
        cluster_obj = TRUE a cluster object, which can be used to plot the
        clustering.
}
\description{
Apply a clustering algorithm recursively to a given time course.
}
