% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphicalOutputs.R
\name{Fitgraphs}
\alias{Fitgraphs}
\title{Model fit graphs for all models}
\usage{
Fitgraphs(
  ModelType,
  WishFitgraphs,
  ModelPara,
  NumOut,
  Economies,
  PathsGraphs,
  Folder2save,
  verbose
)
}
\arguments{
\item{ModelType}{character. Estimated model type.}

\item{WishFitgraphs}{logical. Set TRUE to generate fit graphs, FALSE otherwise.}

\item{ModelPara}{list. Model parameter estimates (see \code{\link{Optimization}}).}

\item{NumOut}{list. Outputs containing model fit, IRFs, FEVDs, GIRFs, GFEVDs and Term premia.}

\item{Economies}{character vector. Names of the economies included in the system.}

\item{PathsGraphs}{character. Path of the folder in which the graphs will be saved.}

\item{Folder2save}{character. Desired folder path to save outputs.}

\item{verbose}{logical. Flag controlling function messaging.}
}
\description{
Model fit graphs for all models
}
\section{Available Methods}{

- `autoplot(object, type = "Fit")`
}

\examples{
data("ParaSetEx")
data("NumOutEx")
ModelType <- "JPS original"
Economy <- "Brazil"
Fitgraphs(ModelType,
  WishFitgraphs = TRUE, ParaSetEx, NumOutEx, Economy, PathsGraphs = NULL,
  Folder2save = NULL, verbose = FALSE
)

}
