% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calgspn.r
\name{calgspn}
\alias{calgspn}
\title{Calculate group-sequential p-values for multiple hypotheses}
\usage{
calgspn(
  xm = qnorm(matrix(rep(c(0.03, 0.04, 0.01), times = 2), ncol = 3, nrow = 2)),
  alpham = matrix(rep(c(0.02, 0.03, 0.05), each = 2), ncol = 3, nrow = 2),
  critm = matrix(rep(qnorm(c(0.02, 0.03, 0.05)), each = 2), ncol = 3, nrow = 2),
  matrix.list = list(diag(3), diag(3)),
  sided = rep(-1, 2)
)
}
\arguments{
\item{xm}{Matrix of test statistics for hypotheses (in row) and each
interim (in column).}

\item{alpham}{Matrix of cumulative alpha levels for the test statistics \code{xm}.
Must have the same dimensions as \code{xm}. For each row, alpha levels must be}

\item{critm}{Matrix of critical values for the test statistics in \code{xm}. It
should be computed beforehand. Must have the same dimensions as \code{xm}.}

\item{matrix.list}{List of correlation matrices corresponding to each
hypothesis.}

\item{sided}{Integer vector indicating the side of the test:
\itemize{
\item \code{-1}: Reject if test statistic is smaller than or equal to the critical value (one-sided)
\item \code{1}: Reject if test statistic is greater or equal to the critical value (one-sided)
\item \code{0}: Reject if the absolute value of the test statistic is greater than the critical value (two-sided)
}}
}
\value{
List with element \code{pm} containing the group-sequential p-values.
}
\description{
\code{calgspn()} calculates the group-sequential p-values for multiple hypotheses.
}
\examples{
calgspn(
  xm = qnorm(matrix(rep(c(0.03,0.04,0.01),times=2),ncol=3,nrow=2)),
  alpham = matrix(rep(c(0.02,0.03,0.05),each=2),ncol=3,nrow=2),
  critm = matrix(rep(qnorm(c(0.02,0.03,0.05)),each=2),ncol=3,nrow=2),
  matrix.list = list(diag(3),diag(3)),
  sided = rep(-1,2)
)
}
\author{
Xiaodong Luo
}
\concept{group-sequential p-values}
