% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hommeld.r
\name{hommeld}
\alias{hommeld}
\title{Hommel procedure}
\usage{
hommeld(pvalues, alpha, epsilon = 1e-10, precision = 10)
}
\arguments{
\item{pvalues}{Numeric vector of p-values from different endpoints.}

\item{alpha}{Numeric vector of alpha values for the different endpoints.
Vector must be same length as \code{pvalues}.}

\item{epsilon}{Numeric scalar indicating the lower bound for alpha.}

\item{precision}{Integer scalar of the desired number of digits to be used.}
}
\value{
List with element named \code{decisions} containing an index of rejected
hypotheses.
}
\description{
\code{hommeld()} implement the Hommel procedure with different alphas for
different endpoints.
}
\details{
The package \href{https://cran.r-project.org/package=hommel}{hommel}
can handle Hommel procedure with different alpha's for different endpoints,
the function \code{hommeld()} is just a wrapper of \code{\link[hommel:hommel-function]{hommel::hommel()}}.
}
\examples{
hommeld(
  pvalues = runif(5),
  alpha = seq(0.01, 0.025, len = 5),
  epsilon = 1.0e-10,
  precision = 10
)
}
\author{
Xiaodong Luo
}
\concept{Hommel procedure}
