% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiObjMatch.R
\name{compare_matching}
\alias{compare_matching}
\title{Generate covariate balance in different matches}
\usage{
compare_matching(
  matching_result,
  cov_list = NULL,
  display_all = TRUE,
  stat = "mean.diff"
)
}
\arguments{
\item{matching_result}{an object returned by the main matching function
dist_bal_match}

\item{cov_list}{(optional) factor of names of covariates that we want to
evaluate covariate balance on; default is NULL. When set to NULL, the
program will compare the covariates that have been used to construct a
propensity model.}

\item{display_all}{(optional) boolean value of whether to display all the
matches; default is TRUE, where matches at each quantile is displayed}

\item{stat}{(optional) character of the name of the statistic used for
measuring covariate balance; default is "mean.diff". This argument is the
same as used in "cobalt" package, see: \link[cobalt]{bal.tab}}
}
\value{
a dataframe that shows covariate balance in different matches
}
\description{
This is a wrapper function for use in evaluating covariate
balance across different matches. It only works for 'Basic'
version of matching (using \code{dist_bal_match}).
}
\examples{
## Generate matches 
data("lalonde", package="cobalt")
ps_cols <- c("age", "educ", "married", "nodegree", "race")
treat_val <- "treat"
response_val <- "re78"  
pair_dist_val <- c("age", "married", "educ", "nodegree", "race")
my_bal_val <- c("race")
r1s <- c(0.01,1,2,4,4.4,5.2,5.4,5.6,5.8,6)
r2s <- c(0.001)
match_result <- dist_bal_match(data=lalonde, treat_col= treat_val, 
marg_bal_col = my_bal_val, exclusion_penalty=r1s, balance_penalty=r2s, 
dist_col = pair_dist_val, 
propensity_col = ps_cols, max_iter=0)

## Generate table for comparing matches
compare_matching(match_result, display_all = TRUE)
}
