% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{rSkewNorm}
\alias{rSkewNorm}
\title{Random Multivariate Skew Normal}
\usage{
rSkewNorm(n, omega, alpha)
}
\arguments{
\item{n}{sample size}

\item{omega}{correlation matrix   with d dimension}

\item{alpha}{shape parameter vector of dimension d}
}
\value{
A random matrix \eqn{n \times d}
}
\description{
Generate random d-vectors  from the multivariate Skew Normal distribution
}
\examples{
alpha<-c(10,5,0)
omega<-diag(3)
x<-rSkewNorm(20,omega,alpha)

}
\references{
Azzalini, A. with the collaboration of Capitanio, A. (2014).
The Skew-Normal and Related Families. Cambridge University Press,
  IMS Monographs series.

Gy.H.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021, Section 5.1.2
}
\seealso{
Other Random generation: 
\code{\link{rCFUSN}()},
\code{\link{rCFUSSD}()},
\code{\link{rUniS}()}
}
\concept{Random generation}
