% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mk_test_func.R
\name{mkUnivariate}
\alias{mkUnivariate}
\title{Univariate Mann-Kendall Test}
\usage{
mkUnivariate(x)
}
\arguments{
\item{x}{Numeric vector representing a data series.}
}
\value{
A named list
\itemize{
\item \code{statistic}, the estimated Mann-Kendall test statistics.
\item \code{p.value}, the estimated p-value for the test.
}
}
\description{
The functions performs the univariate Mann-Kendall test.
}
\details{
The univariate Mann-Kendall (MK) test is used to detect monotonic trends in a univariate data series.
It tests the null hypothesis (\eqn{h_0}) of no trend, against an alternative.

Let \eqn{(x_1, x_2, ..., x_n)} be a data series of length \eqn{n}, the MK test statistic is
given by:
\deqn{M = \sum_{i=1}^{n-1} \sum_{j=i+1}^{n} sgn(x_j-x_i)}
where \eqn{sgn(\cdot)} is the sign function:
\deqn{
sgn(x)=\begin{cases}
-1 \quad \text{if } x<0, \\
0 \quad \text{if } x=0, \\
+1 \quad \text{if } x>0
\end{cases}
}
Under \eqn{H_0} the test statistic is asymptotically normally distributed with mean and
variance:
\deqn{E(M) = 0}
\deqn{\text{Var}(M)=\frac{n(n-1)(n+5)}{18}}
}
\examples{
# Sample data (Both marginal distributions have trend):
dataMarginalTrend <- generate_data("marginalTrend", n = 50)

# Perform two tailed MK test on sample data:
mkUnivariate(dataMarginalTrend[, 1])
mkUnivariate(dataMarginalTrend[, 2])

}
\references{
\itemize{
\item Hamed, K.H., Rao, A.R., 1998. A modified Mann-Kendall trend test for autocorrelated
data. J. Hydrol. 204 (1–4), 182–196.
\item Kendall, M., (1975). Rank Correlation Methods; Griffin: London.
}
}
\seealso{
\link{mkComponent}: The multivariate extension of this test.
}
