% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustments.R
\docType{data}
\name{adjustments}
\alias{adjustments}
\title{NAEP IRT item adjustments.}
\format{
A data frame with columns
\describe{
\item{source}{source of data, character}
\item{level}{grade or age level of test, integer}
\item{levelType}{"grade" or "age", character}
\item{NAEPid}{test item ID, character}
\item{accommodations}{"accom" or "no-accom", character}
\item{subject}{subject of test, character}
\item{year}{year of test, integer}
\item{adjustment}{"Collapsed" or "Deleted", character}
\item{from}{possible scores before adjustment, character}
\item{to}{possible scores after adjustment, character}
}
}
\usage{
adjustments
}
\description{
This data table contains the item adjustment information that NAEP implemented in scaling from 2000 to 2013.
The handful of items with responses that do not fit the item response models were deleted or had the scoring
categories collapsed before the final scaling. To find all adjustments and deletions for an assessment,
filter the data table by level, subject, and year. Assessments in 2000 also require filtering by accommodations.
}
\examples{
\dontrun{

adj <- NAEPirtparams::adjustments
adj8M2005 <- adj[adj$level == 8 & adj$subject == 'Mathematics' & adj$year == 2005, ]
head(adj8M2005)
     source level levelType  NAEPid accommodations     subject year adjustment    from      to
189 website     8     grade M067202           <NA> Mathematics 2005    Deleted    <NA>    <NA>
190 website     8     grade M052801           <NA> Mathematics 2005    Deleted    <NA>    <NA>
191 website     8     grade M073602           <NA> Mathematics 2005    Deleted    <NA>    <NA>
200 website     8     grade M141301           <NA> Mathematics 2005  Collapsed 0,1,2,3 0,1,1,2
201 website     8     grade M085701           <NA> Mathematics 2005  Collapsed   0,1,2   0,0,1
202 website     8     grade M145101           <NA> Mathematics 2005  Collapsed 0,1,2,3 0,1,1,1

}
}
\references{
Department of Education, Institute of Education Sciences, National Center for Education Statistics, National Assessment of Educational Progress (NAEP), 1990-2015, various subjects. Retrieved from \url{https://nces.ed.gov/nationsreportcard/tdw/analysis/scaling_avoidviolat_treatment.aspx}
}
\keyword{datasets}
