% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timemachine_bin.R
\name{timemachine_bin}
\alias{timemachine_bin}
\title{Time machine analysis for binary data}
\usage{
timemachine_bin(
  data,
  arm,
  alpha = 0.025,
  prec_theta = 0.001,
  prec_eta = 0.001,
  tau_a = 0.1,
  tau_b = 0.01,
  bucket_size = 25,
  check = TRUE,
  ...
)
}
\arguments{
\item{data}{Data frame with trial data, e.g. result from the \code{datasim_bin()} function. Must contain columns named 'treatment', 'response' and 'period'.}

\item{arm}{Integer. Index of the treatment arm under study to perform inference on (vector of length 1). This arm is compared to the control group.}

\item{alpha}{Double. Decision boundary (one-sided). Default=0.025.}

\item{prec_theta}{Double. Precision (\eqn{1/\sigma^2_{\theta}}) of the prior regarding the treatment effect \eqn{\theta}. I.e. \eqn{\theta \sim N(0, \sigma^2_{\theta})} . Default=0.001.}

\item{prec_eta}{Double. Precision (\eqn{1/\sigma^2_{\eta_0}}) of the prior regarding the control log-odds \eqn{\eta_0}. I.e. \eqn{\eta_0 \sim N(0, \sigma^2_{\eta_0})}. Default=0.001.}

\item{tau_a}{Double. Parameter \eqn{a_{\tau}} of the Gamma distribution for the precision parameter \eqn{\tau} in the model for the time trend. I.e., \eqn{\tau \sim Gamma(a_{\tau},b_{\tau})}. Default=0.1.}

\item{tau_b}{Double. Parameter \eqn{b_{\tau}} of the Gamma distribution for the precision parameter \eqn{\tau} in the model for the time trend. I.e., \eqn{\tau \sim Gamma(a_{\tau},b_{\tau})}. Default=0.01.}

\item{bucket_size}{Integer. Number of patients per time bucket. Default=25.}

\item{check}{Logical. Indicates whether the input parameters should be checked by the function. Default=TRUE, unless the function is called by a simulation function, where the default is FALSE.}

\item{...}{Further arguments passed by wrapper functions when running simulations.}
}
\value{
List containing the following elements regarding the results of comparing \code{arm} to control:
\itemize{
\item \code{p-val} - posterior probability that the log-odds ratio is less than zero
\item \code{treat_effect} - posterior mean of log-odds ratio
\item \code{lower_ci} - lower limit of the (1-2*\code{alpha})*100\% credible interval for log-odds ratio
\item \code{upper_ci} - upper limit of the (1-2*\code{alpha})*100\% credible interval for log-odds ratio
\item \code{reject_h0} - indicator of whether the null hypothesis was rejected or not (\code{p_val} < \code{alpha})
}
}
\description{
This function performs analysis of binary data using the Time Machine approach. It takes into account all data until the investigated arm leaves the trial. It is based on logistic regression with treatment as a categorical variable and covariate adjustment for time via a second-order Bayesian normal dynamic linear model (separating the trial into buckets of pre-defined size).
}
\details{
The Time Machine divides the trial duration into \eqn{C} calendar time intervals of equal length ("buckets"), which are indexed backwards in time. That is to say, the most recent time interval is denoted by \eqn{c=1} and the time interval corresponding to the beginning of the trial by \eqn{c=C}.
The analysis is performed as soon as the analyzed treatment arm finishes in the trial.

The model is defined as follows:

\deqn{g(E(y_j)) = \eta_0 + \theta_{k_j} + \alpha_{c_j}}

where \eqn{y_j} is the binary response for patient \eqn{j} and \eqn{g(\cdot)} is the logit link function, which maps the expected value of the patient response to the linear predictors in the model.
The model intercept \eqn{\eta_0} denotes the response of the control group at time of the analysis, \eqn{\theta_{k_j}} is the effect of the treatment arm \eqn{k} that patient \eqn{j} was enrolled in, relative to control in terms of the log odds ratio.
For the parameters \eqn{\eta_0} and \eqn{\theta_{k_j}}, normal prior distributions are assumed, with mean 0 and variances \eqn{\sigma^2_{\eta_0}} and \eqn{\sigma^2_{\theta}}, respectively:

\deqn{\eta_0 \sim \mathcal{N}(0, \sigma^2_{\eta_0})}

\deqn{\theta_{k_j} \sim \mathcal{N}(0, \sigma^2_{\theta})}

In the Time Machine, time effect is represented by \eqn{\alpha_{c_j}}, which is the change in the response in time bucket \eqn{c_j} (which denotes the time bucket in which patient \eqn{j} is enrolled) compared to the most recent time bucket \eqn{c=1} and is modeled using a Bayesian second-order normal dynamic linear model.
This creates a smoothing over the control response, such that closer time buckets are modeled with more similar response rates:

\deqn{\alpha_1 = 0}
\deqn{\alpha_2 \sim \mathcal{N}(0, 1/\tau)}
\deqn{\alpha_c \sim \mathcal{N}(2 \alpha_{c-1} - \alpha_{c-2}, 1/\tau), 3 \le c \le C}

where \eqn{\tau} denotes the drift parameter that controls the degree of smoothing over the time buckets and is assumed to have a Gamma hyperprior distribution:

\deqn{\tau \sim Gamma(a_{\tau}, b_{\tau})}
}
\examples{

trial_data <- datasim_bin(num_arms = 3, n_arm = 100, d = c(0, 100, 250),
p0 = 0.7, OR = rep(1.8, 3), lambda = rep(0.15, 4), trend="stepwise")

timemachine_bin(data = trial_data, arm = 3)


}
\references{
The Bayesian Time Machine: Accounting for Temporal Drift in Multi-arm Platform Trials. Saville, B. R., Berry, D. A., et al. Clinical Trials 19.5 (2022): 490-501.
}
\author{
Dominic Magirr, Peter Jacko
}
