% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoglikNCSCop.R
\name{LoglikNCSCop}
\alias{LoglikNCSCop}
\title{Log-likelihood of a non-central squared copula}
\usage{
LoglikNCSCop(alpha, U, family, p = 2)
}
\arguments{
\item{alpha}{unconstrained non-centrality parameters a1, a2, and unconstrained copula parameters.}

\item{U}{(nx2) data matrix of pseudo-observations.}

\item{family}{'Gaussian' , 't' , 'Clayton' , 'Frank' , 'Gumbel'.}

\item{p}{number of different non-centrality parameters (0,1,2 default).}
}
\value{
\item{LL}{Vector of log-likelihoods}
}
\description{
This function computes the log-likelihood vector of a non-central squared copula
}
\examples{
alpha = c(log(0.2),log(5),log(2),log(12));
param = c(0.5,2.5,0.5);
data = SimNCSCop('Clayton', 250, param);
LL = LoglikNCSCop(alpha,data,'Clayton')


}
\author{
Bouchra R. Nasri, August 14, 2019
}
