% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptd_create_ggplot.R
\name{ptd_create_ggplot}
\alias{ptd_create_ggplot}
\title{Create ggplot2}
\usage{
ptd_create_ggplot(
  x,
  point_size = 4,
  percentage_y_axis = FALSE,
  main_title,
  x_axis_label,
  y_axis_label,
  fixed_x_axis_multiple = TRUE,
  fixed_y_axis_multiple = TRUE,
  x_axis_date_format = "\%d/\%m/\%y",
  x_axis_breaks = NULL,
  y_axis_breaks = NULL,
  label_limits = FALSE,
  icons_size = 8L,
  icons_position = c("top right", "bottom right", "bottom left", "top left", "none"),
  colours = ptd_spc_colours(),
  theme_override = NULL,
  break_lines = c("both", "limits", "process", "none"),
  ...
)
}
\arguments{
\item{x}{An object created by \code{\link[=ptd_spc]{ptd_spc()}}}

\item{point_size}{Specify the plotting point size for the ggplot2 output.
The default is 2.5.}

\item{percentage_y_axis}{Specify whether the y axis values are percentages.
Accepted values are \code{TRUE} for a percentage y axis, or \code{FALSE} for an
integer y axis. Defaults to \code{FALSE}.}

\item{main_title}{Specify a character string value for the plot title.}

\item{x_axis_label}{Specify a character string value for the x axis title.}

\item{y_axis_label}{Specify a character string value for the y axis title.}

\item{fixed_x_axis_multiple}{Specify whether, if producing a faceted spc,
the x axis should be fixed for all facet plots. Accepted values are \code{TRUE}
for fixed x axes or \code{FALSE} for individual x axes.}

\item{fixed_y_axis_multiple}{Specify whether, if producing a faceted spc,
the y axis should be fixed for all facet plots. Accepted values are \code{TRUE}
for fixed y axes or \code{FALSE} for individual y axes.}

\item{x_axis_date_format}{Specify how dates on the x axis should be
displayed. The format should be provided as a character string using 'd m Y'
-type syntax.}

\item{x_axis_breaks}{Specify an interval value for breaks on the x axis.
The value should be a character string expressing interval length and type,
e.g. "3 months", "7 days".}

\item{y_axis_breaks}{Specify an interval value for breaks on the y axis.
The value should be a numeric vector of length 1, either an integer for
integer scales or a decimal value for percentage scales. This option is
ignored if faceting is in use.}

\item{label_limits}{Whether to add a secondary y axis that just provides
labels for the values of the UCL, LCL and mean. The default is \code{FALSE}.}

\item{icons_size}{The size of the icons, defined in terms of font size.
Defaults to 8.}

\item{icons_position}{Where to show the icons, either "top right" (default),
"bottom right", "bottom left", "top left", or "none".}

\item{colours}{Specify the colours to use in the plot. Use the
\code{\link[=ptd_spc_colours]{ptd_spc_colours()}} function to change defaults.}

\item{theme_override}{Specify a list containing ggplot2 theme elements that
can be used to override the default appearance of the plot.}

\item{break_lines}{Whether to break lines when a rebase happens. Defaults to
"both", but can break just "limits" lines, "process" lines, or "none".}

\item{...}{Currently ignored}
}
\value{
A ggplot2 object
}
\description{
Creates a ggplot2 object using the parameters passed in.
}
