% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FrCtrl.R
\name{FrCtrl}
\alias{FrCtrl}
\title{Create a frequency table of the control values}
\usage{
FrCtrl(data.nm, data.control, id, nano, dose, end, end.cat, unit,
  unit.cat, vars)
}
\arguments{
\item{data.nm}{Data containing the result of toxicity study}

\item{data.control}{Data of control values}

\item{id}{Identifier of the experiment}

\item{nano}{Name of the nanomaterial}

\item{dose}{Dose or concentration}

\item{end}{Toxicity endpoint}

\item{end.cat}{Specific toxicity endpoint of interest}

\item{unit}{Unit of measurement of the dose}

\item{unit.cat}{Specific unit of measurement of the dose}

\item{vars}{Variables used to subset the data}
}
\value{
The value returned from \code{FrCtrl} is a table containing:
\itemize{
  \item{\code{Freq(Dose=0.0).same}: frequency of control values with dose
  measured in \code{unit.cat}}
  \item{\code{Freq(obs).same}: number of observations with dose measured in
  \code{unit.cat}}
  \item{\code{Freq(Dose=0.0).all}: frequency of control values with dose
  measured \code{unit.cat} and in other units of measurement}
  \item{\code{Freq(obs).all}: number of observations with dose measured in
  \code{unit.cat} and control dose measured in any units},
  }
  for each nanomaterial or subset of data
}
\description{
This function provides a table containing the frequencies of the control
values and the number of available data in the specified dataset. Since it is
possible to have a dose with different units of measurement in one dataset,
this function helps in showing how many control values are available for each
nanomaterial for a specific unit of measurement of the dose.
}
\details{
\itemize{
\item{This function performs data exploration for each nanomaterial in the
dataset (or for each subset of data). The different types of nanomaterials
are identified by their names. Therefore, if some control values are named
differently (see: \code{\link{geninvitro}} dataset and the \code{Examples}),
a separate dataset containing only these values first needs to be created.
Controls in the new dataset can be linked to the non-control observations
belonging to the same experiment through the identifier of the experiment
(the linking is performed inside this function). In this situation, it is
necessary to have an indicator that can identify different experiments (such
as experiment ID).}
\item{If all controls in the dataset are named according to the related
nanomaterial names, \code{data.control} and \code{id} do not need to be
specified.}
\item{The exploration can also be performed on the subsets of data by
splitting the data of each nanomaterial according to the variable(s)
specified in \code{vars}}
}
}
\examples{
# Create a dataset containing controls (which are named differently)
# from geninvitro dataset:
controldata<-SubsetData(data=geninvitro, x="name", x.cat=c("control", "Control",
             "medium", "medium + BSA", "untreated"))

# Exclude controls (which are named differently) from geninvitro dataset:
invitrodata<-SubsetData(data=geninvitro, x="name", x.cat=c("control", "Control",
             "medium", "medium + BSA", "untreated"), include=FALSE)

# Frequency of controls for each nanomaterial in geninvitro dataset
# with DNA STRAND BREAKS as the toxicity endpoint and concentration
# measured in "ug/cm2":
#
FrCtrl(data.nm=invitrodata, data.control=controldata, nano="name",
       end="endpoint", end.cat="DNA STRAND BREAKS", id="experimentID",
       dose="concentration", unit="concentration_unit", unit.cat="ug/cm2")

# Frequency of controls for each cell type in each nanomaterial
# (in geninvitro dataset) with DNA STRAND BREAKS as the toxicity
# endpoint and concentration measured in "ug/cm2":
#
FrCtrl(data.nm=invitrodata, data.control=controldata, nano="name",
       end="endpoint", end.cat="DNA STRAND BREAKS", id="experimentID",
       dose="concentration", unit="concentration_unit", unit.cat="ug/cm2",
       vars="celltype")
}
