% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Frtab.sub.R
\name{Frtab.sub}
\alias{Frtab.sub}
\title{Count the number of observations for each unique value of a variable on a
subset of data}
\usage{
Frtab.sub(data.nm, data.control, id, nano, dose, end, end.cat, unit,
  unit.cat, control.opt=c("same","all"), x)
}
\arguments{
\item{data.nm}{Data containing the result of toxicity study}

\item{data.control}{Data of control values}

\item{id}{Identifier of the experiment}

\item{nano}{Name of the nanomaterial}

\item{dose}{Dose or concentration}

\item{end}{Toxicity endpoint}

\item{end.cat}{Specific toxicity endpoint of interest}

\item{unit}{Unit of measurement of the dose}

\item{unit.cat}{Specific unit of measurement of the dose}

\item{control.opt}{Option for the control doses. If only control doses with
the same unit of measurement as the non-control ones are included, then
specify "\code{same}" in the \code{control.opt}. If all control doses with
any units of measurement are included, then specify "\code{all}".}

\item{x}{Variable to be explored}
}
\value{
This function generates a table containing the number of observations
  for each unique value of a variable on a subset of data
}
\description{
This function counts the number of observations for each unique value of a
variable on a subset of data. The subset of data is created according to the
specified endpoint and unit of measurement of the dose.
}
\details{
\itemize{
\item{This function counts for each nanomaterial in the dataset. The
different types of nanomaterials are identified by their names. Therefore, if
some control values are named differently (see: \code{\link{geninvitro}}
dataset and the \code{Examples}), a separate dataset containing only these
values first needs to be created. Controls in the new dataset can be linked
to the non-control observations belonging to the same experiment through the
identifier of the experiment (the linking is performed inside this function).
In this situation, it is necessary to have an indicator that can identify
different experiments (such as experiment ID).}
\item{If all controls in the dataset are named according to the related
nanomaterial names, \code{data.control} and \code{id} do not need to be
specified.}
\item{If doses used in the experiment are all measured in the same unit of
measurement, then specify "\code{same}" in \code{control.opt}}.
}
}
\examples{
# Create a dataset containing controls (which are named differently)
# from geninvitro dataset:
controldata<-SubsetData(data=geninvitro, x="name", x.cat=c("control",
             "Control", "medium", "medium + BSA", "untreated"))

# Exclude controls (which are named differently) from geninvitro dataset:
invitrodata<-SubsetData(data=geninvitro, x="name", x.cat=c("control",
             "Control", "medium", "medium + BSA", "untreated"), include=FALSE)

# Frequency of each unique value of the dose for each nanomaterial
# in geninvitro dataset, with DNA STRAND BREAKS as the toxicity endpoint
# and only observations with concentration measured in "ug/cm2" are considered:
#
Frtab.sub(data.nm=invitrodata, data.control=controldata, nano="name",
           end="endpoint", end.cat="DNA STRAND BREAKS", id="experimentID",
           dose="concentration", unit="concentration_unit", unit.cat="ug/cm2",
           control.opt="same", x="concentration")

}
