% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz_nue.R
\name{plot_nue_compare}
\alias{plot_nue_compare}
\title{Plot NUE Comparison}
\usage{
plot_nue_compare(data, x_var, y_var)
}
\arguments{
\item{data}{A dataframe containing the results.}

\item{x_var}{The column name to group by (e.g., "Treatment", "Year").}

\item{y_var}{The NUE metric to plot (e.g., "AE", "NRE").}
}
\value{
A ggplot object.
}
\description{
Creates a bar chart comparing NUE metrics across different groups (e.g., Treatments or Sites).
Includes error bars (Standard Error).
}
\examples{
# Create dummy data
df <- data.frame(
  Treat = c("A", "A", "B", "B"),
  AE = c(10, 12, 20, 22)
)

# Plot
plot_nue_compare(df, x_var = "Treat", y_var = "AE")
}
