% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighb.R
\name{neighb}
\alias{neighb}
\title{Compute standard errors and confidence intervals}
\usage{
neighb(RDS.data, quant=c(0.025, 0.975),
      method=c("percentile","Wald"), B=1000)
}
\arguments{
\item{RDS.data}{A list containing the following objects:
\describe{
\item{\code{nodes}}{ a numeric vector containing IDs}
\item{\code{edges}}{ a list containing two vectors: \code{node1} for the recruiter's ID and \code{node2} for the recruit's ID.  }
\item{\code{traits}}{a data frame containing respondents' traits. }
\item{\code{degree}}{a vector containing each node's degree, or number of social connections. }
}}

\item{quant}{a vector of positive integers between 0 and 1, representing quantiles to be estimated.}

\item{method}{a character string representing the method for computing confidence intervals,
either \code{percentile} or \code{Wald}. Default is \code{percentile}.}

\item{B}{the number of bootstrap repetitions. Default is 1000.}
}
\value{
A matrix of estimated standard errors and quantiles. Each row represents a trait.
}
\description{
This function estimate standard errors and compute confidence intervals from
an RDS sample using the neighborhood bootstrap method.
}
\details{
The function \code{neighb} compute standard errors and confidence intervals using
         the neighborhood bootstrap method for RDS. Confidence intervals can be computed using
         the percentile method or the studentized method.
}
\examples{
#Load the synthetic population network dataset.
data("pop.network")

#Draw an RDS sample from the simulated network using the sampleRDS function
#from the package RDStreeboot.
require(RDStreeboot)
RDS.samp <- sample.RDS(pop.network$traits, pop.network$adj.mat, 200, 10,
 3, c(1/6,1/3,1/3,1/6), FALSE)

#Compute 95\\% confidence intervals using the percentile method
neighb(RDS.data=RDS.samp, quant=c(0.025, 0.975),method="percentile", B=100)
}
\author{
Mamadou Yauck <yauck.mamadou@uqam.ca> and Erica E. M. Moodie.
}
