% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netint.R
\name{align.networks}
\alias{align.networks}
\title{Function to align the adjacency matrices of graphs/networks}
\usage{
align.networks(fill = 0, ...)
}
\arguments{
\item{fill}{value used for the missing elements (def: 0).}

\item{...}{a list of numeric matrices. These must be named matrices, and
corresponding elements in different matrices must have the same name.}
}
\value{
list of matrices : they correspond exactly and in the same order to
the input matrices, but they are filled with rows and columns when they have
missed values. The missing values are filled with fill.
}
\description{
It accepts a list of adjacency matrices (that is an arbitrary number
of matrices separated by commas) and returns another list of adjacency matrices
having as elements the union of the elements of all the matrices.
Missed elements are replaced with null rows and columns. In this way the
resulting matrices have the same number of rows/columns in the same order.
}
\examples{
# Create three example networks of different size
set.seed(123);
A1 <- matrix(runif(100, min = 0, max = 1), nrow = 10);
A1[lower.tri(A1)] = t(A1)[lower.tri(A1)];
diag(A1) <- 0;
rownames(A1) <- colnames(A1) <- sample(LETTERS, 10);

A2 <- matrix(runif(49, min = 0, max = 1), nrow = 7);
A2[lower.tri(A2)] = t(A2)[lower.tri(A2)];
diag(A2) <- 0;
rownames(A2) <- colnames(A2) <- rownames(A1)[1:7];

A3 <- matrix(runif(100, min = 0, max = 1), nrow = 10);
A3[lower.tri(A3)] = t(A3)[lower.tri(A3)];
diag(A3) <- 0;
rownames(A3) <- colnames(A3) <- c(rownames(A1)[1:5], c("A", "B", "Z", "K", "Q"));

# Align networks
A_aligned <- align.networks(fill = 0, A1, A2, A3);
}
