% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\name{NLany}
\alias{NLany}
\alias{any}
\alias{NLany,matrix-method}
\title{Any agents?}
\usage{
NLany(agents)

\S4method{NLany}{matrix}(agents)
}
\arguments{
\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
column \code{pycor} representing the \code{patches} coordinates, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{          `AgentMatrix` object representing the moving `agents`.
}\if{html}{\out{</div>}}}
}
\value{
Logical. \code{TRUE} if there is at least one patch or one turtle in the
\code{agents}, \code{FALSE} otherwise.
}
\description{
Report \code{TRUE} if \code{agents} is non empty, report \code{FALSE} otherwise.
}
\examples{
# Patches
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
p1 <- noPatches()
p2 <- patch(w1, 0, 0)
NLany(p1)
NLany(p2)

# Turtles
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))
t2 <- noTurtles()
NLany(t1)
NLany(t2)

}
\references{
Wilensky, U. 1999. NetLogo. \url{https://www.netlogo.org}.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://docs.netlogo.org/dictionary.html#any}
}
\author{
Sarah Bauduin
}
