% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawpostanalysis.R
\name{drawPostAnalysis}
\alias{drawPostAnalysis}
\title{Plot of latent node cluster}
\usage{
drawPostAnalysis(
  mcmcout,
  Y,
  point.cex = 3,
  text.cex = 3,
  segment.size = 0.1,
  n.cluster = NULL,
  start = 1,
  frequency = 1
)
}
\arguments{
\item{mcmcout}{NetworkChange output}

\item{Y}{Input raw data}

\item{point.cex}{node point size.  Default is 3.}

\item{text.cex}{node label size.  Default is 3.}

\item{segment.size}{segment size.  Default is 0.1.}

\item{n.cluster}{number of cluster. Default is 3.}

\item{start}{start of ts object}

\item{frequency}{frequency of ts object}
}
\value{
A plot object
}
\description{
Plot latent node cluster
}
\examples{

   \dontrun{
   set.seed(1973)
   ## generate an array with two constant blocks
   data(MajorAlly)
   Y <- MajorAlly
   fit <- NetworkChange(newY, R=2, m=2, mcmc=G, initial.s = initial.s,
          burnin=G, verbose=0, v0=v0, v1=v1)
   drawPostAnalysis(fit, Y, n.cluster=c(4, 4, 3))
   }
}
\references{
Jong Hee Park and Yunkyun Sohn. 2020. "Detecting Structural Change
in Longitudinal Network Data." \emph{Bayesian Analysis}. Vol.15, No.1, pp.133-157.
}
