% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_valid_NDR_objects.R
\name{test_valid_ndr_object}
\alias{test_valid_ndr_object}
\title{Tests if an object is a valid NDR object}
\usage{
test_valid_ndr_object(ndr_object)
}
\arguments{
\item{ndr_object}{An object that should be an NDR object.}
}
\value{
Returns a string if the \code{ndr_object} is a valid NDR object. The
string is either 'ds', 'fp', 'cl', 'rm' or 'cv' which specifies what type
of object it is. If \code{ndr_object} is not an NDR object, then an error is
thrown.
}
\description{
This function takes an object and tests whether it is a valid NDR object;
i.e., whether it is an object that is either an DS, FP, CL, RM or CV object.
If it is a valid NDR object, then it returns a string specifying the prefix
of the type of object it is; i.e., 'ds', 'fp', 'cl', 'rm' or 'cv'. If it
is not an NDR object then an error is thrown.
}
\keyword{internal}
