% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTAR_ECM.R
\name{MTAR_ECM}
\alias{MTAR_ECM}
\title{MTAR Vector Error Correction Model}
\usage{
MTAR_ECM(y, x, lags)
}
\arguments{
\item{y}{series name,}

\item{x}{series name}

\item{lags}{lag length}
}
\value{
"Model" Estimated model

"AIC" Akaike information criteria

"BIC" Schwarz information criteria
}
\description{
This function allows you to estimate MTAR Vector Error Correction Model with threshold=0
}
\examples{
x <- cumsum(rnorm(1000))
y <- cumsum(rnorm(1000))
MTAR_ECM(x, y, lags = 6)

data(MarketPrices)
MTAR_ECM(MarketPrices[,1],MarketPrices[,2],lags = 2)

}
\references{
Enders, W., & Siklos, P. L. (2001). Cointegration and threshold adjustment. Journal of Business & Economic Statistics, 19(2), 166-176.


Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{MTAR}
\keyword{correction}
\keyword{error}
\keyword{model}
\keyword{vector}
