% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ODT.R
\name{predict.ODT}
\alias{predict.ODT}
\title{making predict based on ODT objects}
\usage{
\method{predict}{ODT}(
  object,
  Xnew,
  Xsplit = NULL,
  type = c("pred", "leafnode", "prob")[1],
  ...
)
}
\arguments{
\item{object}{An object of class ODT, the same as that created by the function \code{\link{ODT}}.}

\item{Xnew}{An n by d numeric matrix (preferable) or data frame. The rows correspond to observations and columns correspond to features.
Note that if there are NA values in the data 'Xnew', which will be replaced with the average value.}

\item{Xsplit}{Splitting variables used to construct linear model trees. The default value is NULL and is only valid when \code{split="linear"}.}

\item{type}{Type of prediction required. Choosing \code{"pred"} (default) gives the prediction result, and choosing \code{"leafnode"} gives the leaf node sequence number that \code{Xnew} is partitioned into.
For classification tasks, including classification trees (\code{split= "gini" or "entropy"}) and linear classification models (\code{split= "linear" and glmnetParList= list(family="binomial" or "multinomial")}). Setting \code{type="prob"} gives the prediction probabilities.}

\item{...}{Arguments to be passed to methods.}
}
\value{
A vector of the following:
\itemize{
\item pred: the prediced response of the new data.
\item leafnode: the leaf node sequence number that the new data is partitioned.
\item prob: the prediction probabilities for classification tasks.
}
}
\description{
Prediction of ODT for an input matrix or data frame.
}
\examples{
# Classification with Oblique Decision Tree.
data(seeds)
set.seed(221212)
train <- sample(1:209, 100)
train_data <- data.frame(seeds[train, ])
test_data <- data.frame(seeds[-train, ])
tree <- ODT(varieties_of_wheat ~ ., train_data, split = "entropy")
pred <- predict(tree, test_data[, -8])
# classification error
(mean(pred != test_data[, 8]))
(prob <- predict(tree, test_data[, -8], type = "prob"))

# Regression with Oblique Decision Tree.
data(body_fat)
set.seed(221212)
train <- sample(1:252, 100)
train_data <- data.frame(body_fat[train, ])
test_data <- data.frame(body_fat[-train, ])
tree <- ODT(Density ~ ., train_data, split = "mse")
pred <- predict(tree, test_data[, -1])
# estimation error
mean((pred - test_data[, 1])^2)

# Use "Z" as the splitting variable to build a linear model tree for "X" and "y".
set.seed(1)
n <- 200
p <- 10
q <- 5
X <- matrix(rnorm(n * p), n, p)
Z <- matrix(rnorm(n * q), n, q)
y <- (Z[, 1] > 1) * (X[, 1] - X[, 2] + 2) +
  (Z[, 1] < 1) * (Z[, 2] > 0) * (X[, 1] + X[, 2] + 0) +
  (Z[, 1] < 1) * (Z[, 2] < 0) * (X[, 3] - 2)
my.tree <- ODT(
  X = X, y = y, Xsplit = Z, split = "linear",
  NodeRotateFun = "RotMatRF", MinLeaf = 10, MaxDepth = 5,
  glmnetParList = list(lambda = 0.1, family = "gaussian")
)
(leafnode <- predict(my.tree, X, Xsplit = Z, type = "leafnode"))
\donttest{
y1 <- (y > 0) * 1
my.tree <- ODT(
  X = X, y = y1, Xsplit = Z, split = "linear",
  NodeRotateFun = "RotMatRF", MinLeaf = 10, MaxDepth = 5,
  glmnetParList = list(family = "binomial")
)
(class <- predict(my.tree, X, Xsplit = Z, type = "pred"))
(prob <- predict(my.tree, X, Xsplit = Z, type = "prob"))

y2 <- (y < -2.5) * 1 + (y >= -2.5 & y < 2.5) * 2 + (y >= 2.5) * 3
my.tree <- ODT(
  X = X, y = y2, Xsplit = Z, split = "linear",
  NodeRotateFun = "RotMatRF", MinLeaf = 10, MaxDepth = 5,
  glmnetParList = list(family = "multinomial")
)
(prob <- predict(my.tree, X, Xsplit = Z, type = "prob"))
}

}
\references{
Zhan, H., Liu, Y., & Xia, Y. (2022). Consistency of The Oblique Decision Tree and Its Random Forest. arXiv preprint arXiv:2211.12653.
}
\seealso{
\code{\link{ODT}} \code{\link{predict.ODRF}}
}
\keyword{predict}
\keyword{tree}
