% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ods_secondary.R
\name{secondary_ODS}
\alias{secondary_ODS}
\title{Secondary analysis in ODS design}
\usage{
secondary_ODS(SRS, lowerODS, upperODS, NVsample, cutpoint, Z.dim)
}
\arguments{
\item{SRS}{A data matrix for subjects in the simple random sample. The first
column is Y1: the primary outcome for which the ODS scheme is based on. The
second column is Y2: a secondary outcome. The third column is X: the
expensive exposure. Starting from the fourth column to the end is Z: other
covariates.}

\item{lowerODS}{A data matrix for supplemental samples taken from the lower
tail of Y1 (eg. Y1 < a). The data structure is the same as SRS.}

\item{upperODS}{A data matrix for supplemental samples taken from the upper
tail of Y1 (eg. Y1 > b). The data structure is the same as SRS.}

\item{NVsample}{A data matrix for subjects in the non-validation sample.
Subjects in the non-validation sample don't have the expensive exposure X
measured. The data structure is the same as SRS, but the third column
(which represents X) has values NA.}

\item{cutpoint}{A vector of length two that represents the cut off points for
the ODS design. eg. cutpoint <- c(a,b). In the ODS design, a simple random
sample is taken from the full cohort, then two supplemental samples are
taken from \{Y1 < a\} and \{Y1 > b\}, respectively.}

\item{Z.dim}{Dimension of the covariates Z.}
}
\value{
A list which contains parameter estimates, estimated standard error
  for the primary outcome model:
  \deqn{Y_{1}=\beta_{0}+\beta_{1}X+\beta_{2}Z,}{Y1 = beta0 + beta1*X + beta2*Z,}
  and the secondary outcome model:
  \deqn{Y_{2}=\gamma_{0}+\gamma_{1}X+\gamma_{2}Z.}{Y2 = gamma0 + gamma1*X + gamma2*Z.}
  The list contains the following components: \item{beta_paramEst}{parameter estimates
  for beta in the primary outcome model} \item{beta_stdErr}{estimated
  standard error for beta in the primary outcome model}
  \item{gamma_paramEst}{parameter estimates for gamma in the secondary
  outcome model} \item{gamma_stdErr}{estimated standard error for gamma in
  the secondary outcome model}
}
\description{
\code{secondary_ODS} performs the secondary analysis which describes the
association between a continuous scale secondary outcome and the expensive
exposure for data obtained with ODS (outcome dependent sampling) design.
}
\examples{
library(ODS)
# take the example data from the ODS package
# please see the documentation for details about the data set ods_data_secondary
data <- ods_data_secondary

# divide the original cohort data into SRS, lowerODS, upperODS and NVsample
SRS <- data[data[,1]==1,2:ncol(data)]
lowerODS <- data[data[,1]==2,2:ncol(data)]
upperODS <- data[data[,1]==3,2:ncol(data)]
NVsample <- data[data[,1]==0,2:ncol(data)]

# obtain the cut off points for ODS design. For this data, the ODS design
# uses mean plus and minus one standard deviation of Y1 as cut off points.
meanY1 <- mean(data[,2])
sdY1 <- sd(data[,2])
cutpoint <- c(meanY1-sdY1, meanY1+sdY1)

# the data matrix SRS has Y1, Y2, X and Z. Hence the dimension of Z is ncol(SRS)-3.
Z.dim <- ncol(SRS)-3

secondary_ODS(SRS, lowerODS, upperODS, NVsample, cutpoint, Z.dim)
}
