% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niceTree.R
\name{niceTree}
\alias{niceTree}
\title{niceTree function}
\usage{
niceTree(
  tree,
  folder = NULL,
  colors = c("", "#367592", "#39A7AE", "#96D6B6", "#FDE5B0", "#F3908B", "#E36192",
    "#8E4884", "#A83333"),
  fontname = "Roboto",
  fontstyle = "plain",
  shape = "diamond",
  output_format = "png"
)
}
\arguments{
\item{tree}{A party of the trained tree with the treatments assigned to each node.}

\item{folder}{Directory to save the image (default is the current working directory).}

\item{colors}{A vector of colors for the boxes. Can include hex color codes (e.g., "#FFFFFF").}

\item{fontname}{The name of the font to use for the text labels (default is "Roboto").}

\item{fontstyle}{The style of the font (e.g., "plain", "italic", "bold").}

\item{shape}{The format of the boxes for the different genes (e.g., "diamond", "box").}

\item{output_format}{The image format for saving (e.g., "png", "jpg", "svg", "pdf").}
}
\value{
(Invisibly) returns a list. The representation of the tree in the command window and the plot of the tree.
}
\description{
A graphical display of the tree. It can also be saved as an image in the selected directory.
}
\details{
\itemize{
 \item The user has already defined a style for the plot; the parameters
       are set if not modified when calling niceTree.
}
}
\examples{
\donttest{
  # Basic example of how to perform niceTree:
  data("mutations_w12")
  data("drug_response_w12")
  ODTmut <- trainTree(PatientData = mutations_w12,
                       PatientSensitivity = drug_response_w12, minbucket = 10)
  niceTree(ODTmut)

  # Example for plotting the tree trained for gene expressions:
  data("expression_w34")
  data("drug_response_w34")
  ODTExp <- trainTree(PatientData = expression_w34,
                       PatientSensitivity = drug_response_w34, minbucket = 20)
  niceTree(ODTExp)
}

}
