% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StoSOO.R
\name{plotStoSOO}
\alias{plotStoSOO}
\title{Plot 2-D \code{\link[OOR]{StoSOO}} result}
\usage{
plotStoSOO(
  sol,
  lower = rep(0, length(sol$par)),
  upper = rep(1, length(sol$par)),
  levels = NULL,
  add = FALSE,
  cpch = ".",
  lcols = 1,
  ylim = NULL
)
}
\arguments{
\item{sol}{outcome of running \code{\link[OOR]{StoSOO}}, with \code{control$light} set to \code{FALSE}}

\item{lower, upper}{vectors of bounds on the variables.}

\item{levels}{which levels to print. Default to all levels}

\item{add}{if \code{TRUE}, use existing plot}

\item{cpch}{\code{\link[graphics]{points}} \code{pch} code for the centers}

\item{lcols}{color at each level, or a single color for all levels (default)}

\item{ylim}{vector of bounds, required in the 1d case}
}
\description{
Plot bivariate tree structure obtained when running \code{\link[OOR]{StoSOO}}
}
\examples{
#------------------------------------------------------------
# Example 1 : Deterministic optimization with SOO, 1-dimensional function
#------------------------------------------------------------
## Define objective
fun1 <- function(x) return(-guirland(x))

## Optimization
Sol1 <- StoSOO(par = NA, fn = fun1, nb_iter = 1000, 
  control = list(type = "det", verbose = 1, light = FALSE))

## Display objective function and solution found
curve(fun1, n = 1001, ylim = c(-1.3, 0))
abline(v = Sol1$par, col = 'red')
plotStoSOO(Sol1, ylim = c(-1.3, -1.1), add = TRUE)

#------------------------------------------------------------
# Example 2 : Deterministic optimization with SOO, 2-dimensional function
#------------------------------------------------------------
set.seed(42)

## 2-dimensional noiseless objective function, defined on [0, pi/4]^2
fun <- function(x){return(-sin1(x[1]) * sin1(1 - x[2]))}

## Optimizing
Sol <- StoSOO(par = rep(NA, 2), fn = fun, upper = rep(pi/4, 2), nb_iter = 1000,
  control = list(type = 'det', light = FALSE))
  
## Display solution
plotStoSOO(Sol, upper = rep(pi/4, 2))
}
