% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCV_regfunctions.R
\name{reg3}
\alias{reg3}
\title{Nonsmooth regression function with six cusps.}
\usage{
reg3(u)
}
\arguments{
\item{u}{numerical vecror of argument values in the range [0,1].}
}
\value{
The vector of values of \eqn{r_3} corresponding to the values of the vector \eqn{u}.
}
\description{
Nonsmooth regression function \eqn{r_3} with six cusps used in the simulation studies in Savchuk et al. (2013) and Savchuk et al. (2017).
}
\details{
The nonsmooth function \eqn{r_3} can be used in simulation studies.
}
\examples{
\dontrun{
# n=250 data points are generated from r3 by adding the Gaussian noise with sigma=1/500.
# The fixed evenly spaced design is used.
u=seq(0,1,len=1000)
n=250
xdat=(1:n-0.5)/n
ydat=reg3(xdat)+rnorm(n,sd=1/500)
h_oscv=round(h_OSCV_reg(xdat,ydat,1),digits=4) # L_G-based OSCV based on nonsmooth constant
l=loclin(u,xdat,ydat,h_oscv)
dev.new()
plot(xdat,ydat,pch=20,cex=1.5,cex.axis=1.5,cex.lab=1.5,xlab="x",ylab="y",
ylim=c(min(ydat),1.2*max(ydat)))
lines(u,l,'l',lwd=3,col="blue")
lines(u,reg3(u),lwd=3,lty="dashed")
title(main="Data, true regression function and LLE",cex.main=1.7)
legend(-0.05,0.003,legend=paste("h_OSCV=",h_oscv),cex=2,bty="n")
legend(0.65,0.025, legend="n=250",cex=2,bty="n")
legend(0,1.28*max(ydat),legend=c("LLE based on h_OSCV","true regression function"),lwd=c(3,3),
lty=c("solid","dashed"),col=c("blue","black"),bty="n",cex=1.5)
}
}
\references{
\itemize{
  \item Savchuk, O.Y., Hart, J.D., Sheather, S.J. (2013). One-sided cross-validation for nonsmooth regression functions. \emph{Journal of Nonparametric Statistics}, 25(4), 889-904.
  \item Savchuk, O.Y., Hart, J.D. (2017). Fully robust one-sided cross-validation for regression functions. \emph{Computational Statistics}, doi:10.1007/s00180-017-0713-7.
}
}
