% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{LSimpson}
\alias{LSimpson}
\title{A function to compute local Simpson's index}
\usage{
LSimpson (x)
}
\arguments{
\item{x}{an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}
}
\value{
A vector containing the local Simpson's interaction index values 
for each spatial unit
}
\description{
Local Simpson's interaction index measures the probability 
that randomly selected individuals are not in the same group in 
each spatial unit.
}
\examples{
x <- segdata@data[ ,1:2]
LSimpson (x) 
}
\references{
Simpson E. H. (1949) \emph{Measurement of diversity}. 
Nature 163:688
}
\seealso{
Other local indices: \code{\link{LQ}}, 
\code{\link{HLoc}}, \code{\link{LShannon}}
}
