# SCCS %W% %G%
plot.date <- function(x, y,..., xaxt, xlab, ylab) {
    class(x) <- NULL
    if (missing(xlab)) xlab <- deparse(substitute(x))
    if (missing(ylab)) ylab <- deparse(substitute(y))

    if (!missing(xaxt)) plot(x, y, ..., xaxt=xaxt, xlab=xlab, ylab=ylab)
    else {
	plot(x, y, ..., xaxt='n', xlab=xlab, ylab=ylab)
	x <- x[!is.na(x)]
	xd<- date.mdy(x)
	temp <- pretty(x,5)
	delta <- temp[2] - temp[1]
	if (delta <1)
	    temp <- seq(min(x), max(x), 1)
	else if (delta > 182) {   #try to do it in years
	    temp <- xd$year + (x - mdy.date(1,1,xd$year))/365
	    temp <- pretty(temp,5)
	    temp <- mdy.date(1, 1, floor(temp)) + floor((temp%%1)*365)
	    }

	xlim <- par("usr")[1:2]
	temp <- temp[temp>xlim[1] & temp<xlim[2]]
	axis(1, temp, as.character.date(temp))
	}
    }
