/* gee support @(#) gee.sa.c 3.2 94/03/26 */
/* /scsi2/stvjc/PROGRAMMING/CHANLIB/CGEE/gee/SCCS/s.gee.sa.c */

#include "cgee.h"

#define LINK parmvec[0]
#define VARFUN parmvec[1]
#define CORSTR parmvec[2]

main()
{
MATRIX *X, *Y, *ID, *N, *OFFSET;
MATRIX *beta, *nvar, *rvar, *R;
MATRIX *tmp[5000];
char *labs[50];
char cbuf[30];
int p, parmvec[4], M_parm, maxiter=25, silent=1, errorstate, ngrp, maxsz, nobs, i,j;
int scalefix = 0;
double tol=.001, phi;
char junk;
double ncdf();
FILE *of, *fopen(), *lf;

X = matread("X");
Y = matread("Y");
ID = matread("ID");
OFFSET = matread("OFFSET");
N = matread("N");

printf("\n\n");
printf("______________________________________________________\n\n");
printf("  Cgee, standalone, version 3.2 94/03/26 (chanlib).\n");
printf("______________________________________________________\n\n");

printf("  Choose a Link Function:\n");
printf("  _______________________\n\n");
printf("    0 = Identity\n");
printf("    1 = Logarithm\n");
printf("    2 = Logit\n");
printf("    3 = Reciprocal\n");
printf("    4 = Probit\n");
printf("\n  > ");
scanf("%d",&LINK);
scanf("%c",&junk);
printf("\n\n");


printf("  Choose a Variance Function:\n");
printf("  ___________________________\n\n");
printf("    0 = Gaussian\n");
printf("    1 = Poisson\n");
printf("    2 = Binomial\n");
printf("    3 = Gamma\n");
printf("\n  > ");
scanf("%d",&VARFUN);
scanf("%c",&junk);
printf("\n\n");

printf("  Choose a Correlation Structure:\n");
printf("  _______________________________\n\n");
printf("    0 = Identity\n");
printf("    1 = Fixed (in file R)\n");
printf("    2 = Stationary M-dependent\n");
printf("    3 = Non-stationary M-dependent\n");
printf("    4 = Exchangeable\n");
printf("    5 = AR-M\n");
printf("    6 = Unstructured\n");
printf("\n  > ");
scanf("%d", &CORSTR);
scanf("%c",&junk);
printf("\n\n");

LINK   = LINK + 1;
VARFUN = VARFUN + 1;
CORSTR = CORSTR + 1;

/* Printing stuff */
#define Printf( x ) {printf( x ); fprintf(of, x); }
#define Printf2( x , y ) {printf( x , y ); fprintf(of, x, y ); }
#define Matdump( x ) { matdump(x); fmatdump(of, x); }

/* Width of output dec,string etc. */
#define OPW 13
#define rept(d,s) {for ( j=0; j<d; j++ ) {Printf(s);}}

if ( CORSTR == 3 || CORSTR == 4 || CORSTR == 6 )
	{
	switch ( CORSTR-1 )
	  {
	  case stat_M_dep:
	    printf("  You have chosen the Stationary M-dependent correlation structure\n");
	    break;
	  case AR_M:
	    printf("  You have chosen the AR-M correlation structure\n");
	    break;
	  case non_stat_M_dep:
	    printf("  You have chosen the Non-stationary M-dependent correlation structure\n");
	    break;
	  }
	printf("  Please enter a value for M > ");
	scanf("%d",&M_parm);
	scanf("%c",&junk);
	}

nobs = Y->nrows;

ngrp = split( Y, ID, tmp );
maxsz = tmp[0]->nrows;
for ( i = 1 ; i < ngrp ; i++ )
	{
	if ( tmp[i]->nrows > maxsz ) maxsz = tmp[i]->nrows ;
	}

if ( OFFSET->nrows != Y->nrows ) 
	{
	destroy_matrix( OFFSET );
	OFFSET = matsub( Y, Y);
	make_permanent( OFFSET );
	}
if ( N->nrows != Y->nrows ) 
	{
	destroy_matrix( N );
	N = col_1s( nobs );
	make_permanent( N );
	}



beta = matmult( luinv( matmult( transp(X), X ) ), matmult( transp(X), Y ));

p = X->ncols;
nvar = create_matrix( p, p, EPHEMERAL );
rvar = create_matrix( p, p, EPHEMERAL );
if ( CORSTR-1 == (int)fixed ) R = matread("R");
else R = create_matrix( maxsz, maxsz, EPHEMERAL );


X->permanence = EPHEMERAL;
X = transp(X);
X->permanence = PERMANENT;

matdump(beta);

Cgee( X->data, Y->data, ID->data, N->data, OFFSET->data, &nobs, &p,
	parmvec, &M_parm,
	beta->data, nvar->data, rvar->data,
	&phi, R->data, &tol, &maxsz, &maxiter, &silent, &errorstate, &scalefix );

of = fopen("gee.log","a");
lf = fopen("gee.labs","r");

for ( i = 0 ; i < p ; i++ )
	{
	fscanf(lf,"%s\n",&cbuf[0]);
	labs[i] =(char *) calloc( 30, (unsigned)sizeof(char));
	strcpy( labs[i], cbuf );
	}

Printf("\n\n    ___________________________________________________ G E E _________________________________________________\n\n\n");
	{
	Printf("    Cgee used: \n\n");
	switch( LINK-1 )
		{
		case identity:
			Printf("       The Identity link,\n");
			break;
		case logarithm:
			Printf("       The Log link,\n");
			break;
		case logit:
			Printf("       The Logit link,\n");
			break;
		case reciprocal:
			Printf("       The Reciprocal link,\n");
			break;
		case probit:
			Printf("       The Probit link,\n");
			break;
		default:
			Printf("       An Unknown link function,\n");
			break;
		}
	switch ( CORSTR-1 )
		{
		case independence:
			Printf("       An Independent Correlation Structure, and,\n");
			break;
		case exchangeable:
			Printf("       An Exchangeable Correlation Structure, and,\n");
			break;
		case stat_M_dep:
			Printf2("       A Stationary M-dependent Correlation Structure, with M = %d, and,\n",M_parm);
			break;
		case AR_M:
			Printf2("       An AR-M Correlation Structure, with M = %d, and,\n",M_parm);
			break;
		case non_stat_M_dep:
			Printf2("       A Non-stationary M-dependent Correlation Structure, with M = %d, and,\n",M_parm);
			break;
		case unstructured:
			Printf("       An Unstructured Correlation Structure, and,\n");
			break;
		case fixed:
			Printf("       A Fixed Correlation Structure, and,\n");
			break;
		default:
			Printf("       An Unknown Correlation Structure, and,\n");
			break;
		}
	switch( VARFUN-1 )
		{
		case Gaussian:
			Printf("       A Gaussian variance-mean relation.\n");
			break;
		case Poisson:
			Printf("       A Poisson variance-mean relation.\n");
			break;
		case Binomial:
			Printf("       A Binomial variance-mean relation.\n");
			break;
		case Gamma:
			Printf("       A Gamma variance-mean relation.\n");
			break;
		default:
			fprintf( stderr,
			"Cgee: unknown variance-mean relation, program Dies.\n");
			exit( UNKNOWN_VAR_MEAN_REL );
			break;
		}
		}

Printf2("\n    The Tolerance used was %lf\n\n",tol);


Printf("\n");
rept(4," ");
Printf("Working Correlation Structure:");


switch ( CORSTR-1 )
	{
	case independence:
		Printf(" The Identity Matrix\n");
		break;
	case exchangeable:
		Printf(" Exchangeable,");
		Printf2(" with off-diagonal element = %lf\n",MEL(R,1,2));
		break;
	default:
		Printf("\n");
		rept(4," ");rept(OPW*(maxsz),"_");rept(10,"_");Printf("\n\n");
		rept(4," "); Printf(" Cluster  ");
		  for (i=0; i<maxsz; i++ ) Printf2("%13d",i);
		Printf("\n");
		for (i=0; i<maxsz; i++ ) {
		  rept(4," ");
		  Printf2("%5d     ",i);
		  for (j=0; j<maxsz; j++ ) {
		    Printf2("%13.4e",MEL(R,i,j));
		  }
		  Printf("\n");
		}
		rept(4," ");rept(OPW*(maxsz),"_");rept(10,"_");Printf("\n\n");
		break;
      }


/* Matdump(beta); */


Printf("\n\n");
rept(4," ");
Printf("Naive Covariance of Parameter Estimates\n");
rept(4," ");rept(OPW*(p+1),"_");Printf("\n\n");

        rept(4+OPW," ");
	for (i=0; i<p; i++ ) Printf2("%13s",labs[i]);
        Printf("\n");

	for (i=0; i<p; i++ ) {
	  rept(4," ");
	  Printf2("%-13s",labs[i]);
	  for (j=0; j<p; j++ ) Printf2("%13.4E",MEL(nvar,i,j));
	  Printf("\n");
	}
rept(4," ");rept(OPW*(p+1),"_");Printf("\n\n");

/* Matdump(nvar); */

Printf("\n\n");
rept(4," ");
Printf("Robust Covariance of Parameter Estimates\n");
rept(4," ");rept(OPW*(p+1),"_");Printf("\n\n");

        rept(4+OPW," ");
	for (i=0; i<p; i++ ) Printf2("%13s",labs[i]);
        Printf("\n");

	for (i=0; i<p; i++ ) {
          rept(4," ");
	  Printf2("%-13s",labs[i]);
	  for (j=0; j<p; j++ ) Printf2("%13.4E",MEL(rvar,i,j));
	  Printf("\n");
	}
rept(4," ");rept(OPW*(p+1),"_");Printf("\n\n");

/* Matdump(rvar); */

Printf("\n\n");
Printf("    Parameter Estimates\n");
rept(4," ");rept(107,"_");Printf("\n\n");
Printf("    Variable            Parameter       Naive         Naive        Naive       Robust       Robust       Robust\n");
Printf("    Name                 Estimate         SE        Z-Ratio        P>|Z|         SE        Z-Ratio        P>|Z|\n");
rept(4," ");rept(107,"_");Printf("\n\n");
for ( i = 0 ; i < p ; i++ )
	{
	rept(4," ");
	Printf2("%-16s",labs[i]);
	Printf2("%13.5lf",MEL(beta,i,0));
	Printf2("%13.5lf",sqrt(MEL(nvar,i,i)));
	Printf2("%13.5lf",MEL(beta,i,0)/sqrt(MEL(nvar,i,i)));
	Printf2("%13.5lf",2*(1-ncdf(fabs(MEL(beta,i,0)/sqrt(MEL(nvar,i,i))))));
	Printf2("%13.5lf",sqrt(MEL(rvar,i,i)));
	Printf2("%13.5lf",MEL(beta,i,0)/sqrt(MEL(rvar,i,i)));
	Printf2("%13.5lf\n",2*(1-ncdf(fabs(MEL(beta,i,0)/sqrt(MEL(rvar,i,i))))));
	}
rept(4," ");rept(107,"_");Printf("\n\n");

Printf2("    Scale Parameter Estimate = %lf\n",phi);
Printf("\n\n    ___________________________________________________ G E E _________________________________________________\n\n\n");
}


/*
void Cgee( x, y, id, n, offset, nobs, p,
	   parmvec, M_parm, 
	   S_beta, S_naivvar, S_robvar,
	   S_phi, S_R, tol, maxsz, maxiter, silent, errorstate )
double *x, *y, *id, *offset, *n;
int *nobs, *p, *M_parm, *maxiter;
int *silent, *parmvec; 
double *S_beta, *S_naivvar, *S_robvar, *S_phi, *S_R, *tol;
int *maxsz, *errorstate;
*/

