% file nnet/predict.nnet.d copyright (C) 1994-8 W. N. Venables and B. D. Ripley
%
\name{predict.nnet}
\alias{predict.nnet}
\title{
Predict New Examples by a Trained Neural Net
}
\description{
Predict new examples by a trained neural net.
}
\usage{
predict.nnet(object, x, type=c("raw","class"))
}
\arguments{
\item{object}{
an object of class \code{nnet} as  returned by \code{nnet}.
}
\item{x}{
matrix or data frame of test examples. A vector is considered to be
a row vector comprising a single case.
}}
\value{
If \code{type="raw"}, the matrix of values returned by the trained network;
if \code{type="class"}, the corresponding class (which is probably only
useful if the net was generated by \code{nnet.formula}).
}
\details{
This function is a method for the generic function
\code{predict()} for class \code{nnet}.
It can be invoked by calling \code{predict(x)} for an
object \code{x} of the appropriate class, or directly by
calling \code{predict.nnet(x)} regardless of the
class of the object.
}
\seealso{
\code{\link{nnet}}, \code{\link{which.is.max}}
}
\examples{
data(iris3)
# use half the iris data
ir <- rbind(iris3[,,1],iris3[,,2],iris3[,,3])
targets <- class.ind( c(rep("s", 50), rep("c", 50), rep("v", 50)) )
samp <- c(sample(1:50,25), sample(51:100,25), sample(101:150,25))
ir1 <- nnet(ir[samp,], targets[samp,],size=2, rang=0.1,
            decay=5e-4, maxit=200)
test.cl <- function(true, pred){
        true <- max.col(true)
        cres <- max.col(pred)
        table(true, cres)
}
test.cl(targets[-samp,], predict(ir1, ir[-samp,]))


# or
ird <- data.frame(rbind(iris3[,,1], iris3[,,2], iris3[,,3]),
	species=c(rep("s",50), rep("c", 50), rep("v", 50)))
ir.nn2 <- nnet(species ~ ., data=ird, subset=samp, size=2, rang=0.1, 
            decay=5e-4, maxit=200)
table(ird$species[-samp], predict(ir.nn2, ird[-samp,], type="class"))
}
\keyword{neural}
% Converted by Sd2Rd version 0.3-1.
