\name{potthoff}
\title{Potthoff and Roy growth curve model}
\usage{
potthoff(y, x, cov=NULL, times=NULL, torder=0, orthog=T)
}
\alias{potthoff}
\alias{coefficients.potthoff}
\alias{deviance.potthoff}
\alias{print.potthoff}
\alias{residuals.potthoff}
\arguments{
\item{y}{A matrix or dataframe of response values.}
\item{x}{A matrix defining the complete intersubject differences.}
\item{cov}{A matrix of columns of the baseline covariates to be
fitted, with one row per individual.}
\item{times}{A vector of unequally spaced times when they are the same
for all individuals. Not necessary if equally spaced.}
\item{torder}{Order of the polynomial in time to be fitted. If
non-numeric, the full model in time is fitted.}
\item{orthog}{If TRUE, uses orthogonal polynomials for time, otherwise
only centres times at their mean.}
}
\description{
\code{potthoff} fits the Potthoff and Roy repeated measurements growth
curve model with unstructured covariance matrix to completely balanced
data.
}
\value{
A list of class potthoff is returned. 
}
\seealso{
\code{\link{carma}}, \code{\link{elliptic}}, \code{\link{lm}}.
}
\examples{
# full model with treatment effect
potthoff(y, x, torder="f", cov=x)
# no time trend with treatment effect
potthoff(y, x, torder=0, cov=x)
# quadratic time with treatment effect
potthoff(y, x, torder=2, cov=x)
# full model without treatment effect
potthoff(y, x, torder="f")
# linear time without treatment effect
potthoff(y, x, torder=1)
}