\name{gnlmm}
\title{Fit a Generalized Nonlinear Mixed Model}
\usage{
gnlmm(y, dist="normal", pmu=NULL, pshape=NULL, psd=NULL, mu=NULL,
	shape=NULL, linear=NULL, exact=F, wt=1, delta=1, shfn=F,
	nest=NULL, scale=NULL, points=10, print.level=0, typsiz=abs(p),
	ndigit=10, gradtol=0.00001, stepmax=10*sqrt(p\%*\%p),
	steptol=0.00001, iterlim=100, fscale=1)
}
\alias{gnlmm}
\arguments{
\item{y}{A response vector for uncensored data or a two column
matrix for (beta) binomial data. For censored data, two columns with the
second being the censoring indicator (1: uncensored, 0: right
censored, -1: left censored.) It may also be an object of class,
response (created by \code{\link{restovec}}).}
\item{dist}{Either a character string containing the name of the
distribution or a function giving the -log likelihood and calling the
location and shape functions.}
\item{pmu}{Vector of initial estimates for the location parameters.}
\item{pshape}{Vector of initial estimates for the shape parameters.}
\item{psd}{Initial estimate of the standard deviation of the normal
mixing distribution.}
\item{mu}{User-specified function of \code{pmu}, and possibly \code{linear},
giving the regression equation for the location. This may contain a linear
part as the second argument to the function. It may also be a language
expression beginning with ~, specifying a linear regression function
for the location parameter. If neither is supplied, the location is
taken to be constant unless the linear argument is given.}
\item{shape}{User-specified function of \code{pshape}, and possibly
\code{linear} and/or \code{mu}, giving the regression equation for the
dispersion or shape parameter. This may contain a linear part as the
second argument to the function and the location as last argument. It
may also be a language expression beginning with ~, specifying a
linear regression function for the shape parameter. If neither is
supplied, this parameter is taken to be constant unless the linear
argument is given. This parameter is the logarithm of the usual one.}
\item{linear}{Language expression beginning with ~, specifying the
linear part of the regression function for the location parameter
or list of two such expressions for the location and/or shape parameters.}
\item{exact}{If TRUE, fits the exact likelihood function for
continuous data by integration over intervals of observation,
i.e. interval censoring.}
\item{wt}{Weight vector.}
\item{delta}{Scalar or vector giving the unit of measurement (always
one for discrete data) for each response value, set to unity by
default. For example, if a response is measured to two decimals,
delta=0.01. If the response is transformed, this must be multiplied by
the Jacobian. The transformation cannot contain unknown
parameters. For example, with a log transformation,
\code{delta=1/y}. (The delta values for the censored response are
ignored.)}
\item{shfn}{If true, the supplied shape function depends on the
location (function). The name of this location function must be the
last argument of the shape function.}
\item{nest}{The variable classifying observations by the unit upon
which they were observed. Not necessary if y has class, response.}
\item{scale}{The scale on which the random effect is applied.}
\item{points}{The number of points for Gauss-Hermite integration of
the random effect.}
\item{others}{Arguments controlling \code{\link{nlm}}.}
}
\description{
\code{gnlmm} fits user-specified nonlinear regression equations to one
or both parameters of the common one and two parameter distributions
(binomial, beta binomial, double binomial, Poisson, negative binomial,
double Poisson, Consul generalized Poisson, logarithmic series,
geometric, normal, inverse Gauss, logistic, exponential, gamma,
Weibull, extreme value, Cauchy, Student t, and Laplace; all but the
binomial and beta binomial may be right and/or left censored).

The intercept of the location regression has a normally-distributed
random effect. This normal mixing distribution is computed by
Gauss-Hermite integration.

The \code{scale} of the random effect is the link function to be
applied. For example, if it is \code{log}, the supplied mean function,
\code{mu}, is transformed as log(exp(mu)+sd), where sd is the random
effect parameter.

It is recommended that initial estimates for \code{pmu} and
\code{pshape} be obtained from \code{gnlr}.
}
\value{
A list of class gnlr is returned.
The printed output includes the -log likelihood (not the deviance),
the corresponding AIC, the maximum likelihood estimates, standard
errors, and correlations. A list is returned that contains all of the
relevant information calculated, including error codes.
}
\seealso{
\code{\link{lm}}, \code{\link{glm}}, \code{\link{glmm}},
\code{\link{gnlr}}, \code{\link{gnlr3}}, \code{\link{fmr}}.
}
\examples{
# linear regression with inverse Gauss distribution
mu <- function(p) p[1]+p[2]*sex+p[3]*age
gnlmm(data, dist="inverse Gauss", pmu=rep(1,3), psh=1, psd=1, mu=mu,
	nest=nest)
# or equivalently
gnlmm(data, dist="inverse Gauss", pmu=rep(1,3), psh=1, psd=1,
	mu=~sex+age, nest=nest)
#
# nonlinear regression with inverse Gauss distribution
mu <- function(p) p[4]+exp(p[1]+p[2]*sex+p[3]*age)
gnlmm(data, dist="inverse Gauss", pmu=rep(1,4), psh=1, psd=1, mu=mu,
	nest=nest)
#
# include regression for the shape parameter with same mu function
shape <- function(p) p[1]+p[2]*sex+p[3]*age
gnlmm(data, dist="inverse Gauss", pmu=rep(1,4), psh=rep(1,3), psd=1,
	mu=mu, shape=shape, nest=nest)
}
