% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sign.correction}
\alias{sign.correction}
\title{Directionality of QC metrics}
\format{
A data frame containing the following columns: Metric, Sign
\describe{
\item{Metric}{Quality control metrics, corresponding to the metrics in \code{example.qc.dataframe}}
\item{Sign}{Directionality of each metric; positive (pos) means a higher metric is better, negative (neg) means a lower metric is better}
}
}
\usage{
data(sign.correction)
}
\description{
Directionality of QC metrics
}
\examples{
\donttest{
data(sign.correction)
data(example.qc.dataframe)
correct.zscore.signs(
  zscores = example.qc.dataframe,
  signs.data = sign.correction,
  metric.col.name = 'Metric',
  signs.col.name = 'Sign',
  );
}
}
\keyword{datasets}
