% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{ColorectalMiRNAs_tbl_df}
\alias{ColorectalMiRNAs_tbl_df}
\title{PubMed Data of miRNAs in Colorectal Cancer}
\format{
A tibble with 508 observations and 8 variables:
\describe{
  \item{PMID}{PubMed Identifier (numeric).}
  \item{Year}{Publication year of the article (numeric).}
  \item{Title}{Title of the PubMed article (character).}
  \item{Abstract}{Abstract of the article (character).}
  \item{Language}{Language of the article (character).}
  \item{Type}{Type of publication, e.g., review, study (character).}
  \item{Topic}{Research topic related to colorectal cancer and miRNAs (character).}
  \item{miRNA}{Specific microRNAs mentioned in the publication (character).}
}
}
\source{
Data taken from the miRetrieve package. More information is available at: \url{https://pubmed.ncbi.nlm.nih.gov/}
}
\usage{
data(ColorectalMiRNAs_tbl_df)
}
\description{
This dataset, ColorectalMiRNAs_tbl_df, is a tibble containing information from PubMed abstracts related to microRNAs (miRNAs) in colorectal cancer.
The data provides key details such as publication metadata, article abstracts, and associated miRNAs.
The dataset consists of 508 observations with 8 variables.
}
\details{
The dataset name has been kept as 'ColorectalMiRNAs_tbl_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_tbl_df' indicates that the dataset is a tibble, which is an enhanced version of a data frame in R.
The original content has not been modified in any way.
}
