% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{HeadNeckCarcinoma_df}
\alias{HeadNeckCarcinoma_df}
\title{Head and Neck Squamous-Cell Carcinoma Treatment}
\format{
A data frame with 65 observations and 5 variables:
\describe{
  \item{id}{Trial identifier (numeric).}
  \item{trial}{Name of the trial (character).}
  \item{OmE}{Observed minus expected number of deaths (numeric).}
  \item{V}{Variance of the observed minus expected deaths (numeric).}
  \item{grp}{Treatment group (integer).}
}
}
\source{
Data taken from the metadat package.
Pignon, J. P., Bourhis, J., Domenge, C., & Designe, L. (2000). Chemotherapy added to locoregional treatment for head and neck squamous-cell carcinoma: Three meta-analyses of updated individual data.
Lancet, 355(9208), 949-955. https://doi.org/10.1016/S0140-6736(00)90011-4
}
\usage{
data(HeadNeckCarcinoma_df)
}
\description{
This dataset, HeadNeckCarcinoma_df, is a data frame containing results from 65 trials examining mortality risk in patients with nonmetastatic head and neck squamous-cell carcinoma receiving either locoregional treatment plus chemotherapy versus locoregional treatment alone.
The dataset provides the observed minus expected number of deaths and corresponding variances in the locoregional treatment plus chemotherapy group.
}
\details{
The dataset name has been kept as 'HeadNeckCarcinoma_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
