% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{load_dataset_from_github}
\alias{load_dataset_from_github}
\title{Load Dataset from GitHub Repository}
\usage{
load_dataset_from_github(disease, local_dir = path.expand(getwd()))
}
\arguments{
\item{disease}{A character string specifying the disease, which corresponds
to the name of the dataset to be loaded (e.g., "LUSC"). The function constructs
the filename as \code{tolower(disease)_tcga.rda} and attempts to load this dataset.}

\item{local_dir}{An optional character string specifying the path to the directory
where datasets should be stored locally. If not provided, defaults to a
subdirectory named \code{your_package_name_data} within the user's home directory.
Users can specify their own directory path if they prefer to store data in a different
location.}
}
\value{
Invisible NULL. The function is primarily used for its side effect of
  loading a dataset into the global environment. However, the function itself
  does not return the dataset directly.
}
\description{
Downloads a specified dataset from a GitHub repository if it is not already
present in the specified local directory, then loads the dataset into the global
environment. This function is designed to help manage package size by storing
data externally and loading it on-demand.
}
\examples{
\dontrun{
  load_dataset_from_github("LUSC")
}

}
