% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ml_subtype}
\alias{ml_subtype}
\title{Predict the subtypes of selected cancer type using machine learning}
\usage{
ml_subtype(
  data,
  disease = "LUSC",
  method = "rf",
  removeBatch = TRUE,
  seed = NULL
)
}
\arguments{
\item{data}{data set to predict the subtypes which is a numeric matrix with row names of features and column names of samples}

\item{disease}{character string of the disease to predict subtypes, currently support 'LUSC', 'LUAD', and 'BLCA'.}

\item{method}{character string of the method to use currently support 'rf'.}

\item{removeBatch}{whether do batch effect correction using \code{limma::removeBatchEffect}, default TRUE.}

\item{seed}{integer seed to use.}
}
\value{
An object of class "SubtypeClass" with four slots: genes used for predictiong, predicted subtypes of samples, a matrix of predicting scores, and the method.
}
\description{
Predict the subtypes of selected cancer type using machine learning
}
\examples{
\dontrun{
library(OncoSubtype)
data <- get_median_centered(example_fpkm)
data <- assays(data)$centered
rownames(data) <- rowData(example_fpkm)$external_gene_name
ml_subtype(data, disease = 'LUAD', method = 'rf', seed = 123)
}
}
\references{
\enumerate{
\item \insertRef{wilkerson2010}{OncoSubtype}

\item \insertRef{wilkerson2012}{OncoSubtype}

\item \insertRef{tcga2015}{OncoSubtype}
}
}
